/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.DateArrayOptions;

public class DateArrayOptionsUnmarshaller
implements Unmarshaller<DateArrayOptions, StaxUnmarshallerContext> {
    private static DateArrayOptionsUnmarshaller INSTANCE;

    public DateArrayOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DateArrayOptions.Builder dateArrayOptions = DateArrayOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    dateArrayOptions.defaultValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceFields", targetDepth)) {
                    dateArrayOptions.sourceFields(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FacetEnabled", targetDepth)) {
                    dateArrayOptions.facetEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchEnabled", targetDepth)) {
                    dateArrayOptions.searchEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReturnEnabled", targetDepth)) continue;
                dateArrayOptions.returnEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DateArrayOptions)dateArrayOptions.build();
    }

    public static DateArrayOptionsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DateArrayOptionsUnmarshaller();
        }
        return INSTANCE;
    }
}

