/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.cloudsearch.model.DomainNameMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDomainNamesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDomainNamesResponse> {
    private final Map<String, String> domainNames;

    private ListDomainNamesResponse(BuilderImpl builder) {
        this.domainNames = builder.domainNames;
    }

    public Map<String, String> domainNames() {
        return this.domainNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainNames() == null ? 0 : this.domainNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse)((Object)obj);
        if (other.domainNames() == null ^ this.domainNames() == null) {
            return false;
        }
        return other.domainNames() == null || other.domainNames().equals(this.domainNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainNames() != null) {
            sb.append("DomainNames: ").append(this.domainNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Map<String, String> domainNames = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            this.setDomainNames(model.domainNames);
        }

        public final Map<String, String> getDomainNames() {
            return this.domainNames;
        }

        @Override
        public final Builder domainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
            return this;
        }

        public final void setDomainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
        }

        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDomainNamesResponse> {
        public Builder domainNames(Map<String, String> var1);
    }
}

