/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.services.cloudsearch.model.Limits;
import software.amazon.awssdk.services.cloudsearch.model.ServiceEndpoint;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainStatus
implements ToCopyableBuilder<Builder, DomainStatus> {
    private final String domainId;
    private final String domainName;
    private final String arn;
    private final Boolean created;
    private final Boolean deleted;
    private final ServiceEndpoint docService;
    private final ServiceEndpoint searchService;
    private final Boolean requiresIndexDocuments;
    private final Boolean processing;
    private final String searchInstanceType;
    private final Integer searchPartitionCount;
    private final Integer searchInstanceCount;
    private final Limits limits;

    private DomainStatus(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.arn = builder.arn;
        this.created = builder.created;
        this.deleted = builder.deleted;
        this.docService = builder.docService;
        this.searchService = builder.searchService;
        this.requiresIndexDocuments = builder.requiresIndexDocuments;
        this.processing = builder.processing;
        this.searchInstanceType = builder.searchInstanceType;
        this.searchPartitionCount = builder.searchPartitionCount;
        this.searchInstanceCount = builder.searchInstanceCount;
        this.limits = builder.limits;
    }

    public String domainId() {
        return this.domainId;
    }

    public String domainName() {
        return this.domainName;
    }

    public String arn() {
        return this.arn;
    }

    public Boolean created() {
        return this.created;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public ServiceEndpoint docService() {
        return this.docService;
    }

    public ServiceEndpoint searchService() {
        return this.searchService;
    }

    public Boolean requiresIndexDocuments() {
        return this.requiresIndexDocuments;
    }

    public Boolean processing() {
        return this.processing;
    }

    public String searchInstanceType() {
        return this.searchInstanceType;
    }

    public Integer searchPartitionCount() {
        return this.searchPartitionCount;
    }

    public Integer searchInstanceCount() {
        return this.searchInstanceCount;
    }

    public Limits limits() {
        return this.limits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainId() == null ? 0 : this.domainId().hashCode());
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.created() == null ? 0 : this.created().hashCode());
        hashCode = 31 * hashCode + (this.deleted() == null ? 0 : this.deleted().hashCode());
        hashCode = 31 * hashCode + (this.docService() == null ? 0 : this.docService().hashCode());
        hashCode = 31 * hashCode + (this.searchService() == null ? 0 : this.searchService().hashCode());
        hashCode = 31 * hashCode + (this.requiresIndexDocuments() == null ? 0 : this.requiresIndexDocuments().hashCode());
        hashCode = 31 * hashCode + (this.processing() == null ? 0 : this.processing().hashCode());
        hashCode = 31 * hashCode + (this.searchInstanceType() == null ? 0 : this.searchInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.searchPartitionCount() == null ? 0 : this.searchPartitionCount().hashCode());
        hashCode = 31 * hashCode + (this.searchInstanceCount() == null ? 0 : this.searchInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus)obj;
        if (other.domainId() == null ^ this.domainId() == null) {
            return false;
        }
        if (other.domainId() != null && !other.domainId().equals(this.domainId())) {
            return false;
        }
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.created() == null ^ this.created() == null) {
            return false;
        }
        if (other.created() != null && !other.created().equals(this.created())) {
            return false;
        }
        if (other.deleted() == null ^ this.deleted() == null) {
            return false;
        }
        if (other.deleted() != null && !other.deleted().equals(this.deleted())) {
            return false;
        }
        if (other.docService() == null ^ this.docService() == null) {
            return false;
        }
        if (other.docService() != null && !other.docService().equals(this.docService())) {
            return false;
        }
        if (other.searchService() == null ^ this.searchService() == null) {
            return false;
        }
        if (other.searchService() != null && !other.searchService().equals(this.searchService())) {
            return false;
        }
        if (other.requiresIndexDocuments() == null ^ this.requiresIndexDocuments() == null) {
            return false;
        }
        if (other.requiresIndexDocuments() != null && !other.requiresIndexDocuments().equals(this.requiresIndexDocuments())) {
            return false;
        }
        if (other.processing() == null ^ this.processing() == null) {
            return false;
        }
        if (other.processing() != null && !other.processing().equals(this.processing())) {
            return false;
        }
        if (other.searchInstanceType() == null ^ this.searchInstanceType() == null) {
            return false;
        }
        if (other.searchInstanceType() != null && !other.searchInstanceType().equals(this.searchInstanceType())) {
            return false;
        }
        if (other.searchPartitionCount() == null ^ this.searchPartitionCount() == null) {
            return false;
        }
        if (other.searchPartitionCount() != null && !other.searchPartitionCount().equals(this.searchPartitionCount())) {
            return false;
        }
        if (other.searchInstanceCount() == null ^ this.searchInstanceCount() == null) {
            return false;
        }
        if (other.searchInstanceCount() != null && !other.searchInstanceCount().equals(this.searchInstanceCount())) {
            return false;
        }
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        return other.limits() == null || other.limits().equals(this.limits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainId() != null) {
            sb.append("DomainId: ").append(this.domainId()).append(",");
        }
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.arn() != null) {
            sb.append("ARN: ").append(this.arn()).append(",");
        }
        if (this.created() != null) {
            sb.append("Created: ").append(this.created()).append(",");
        }
        if (this.deleted() != null) {
            sb.append("Deleted: ").append(this.deleted()).append(",");
        }
        if (this.docService() != null) {
            sb.append("DocService: ").append(this.docService()).append(",");
        }
        if (this.searchService() != null) {
            sb.append("SearchService: ").append(this.searchService()).append(",");
        }
        if (this.requiresIndexDocuments() != null) {
            sb.append("RequiresIndexDocuments: ").append(this.requiresIndexDocuments()).append(",");
        }
        if (this.processing() != null) {
            sb.append("Processing: ").append(this.processing()).append(",");
        }
        if (this.searchInstanceType() != null) {
            sb.append("SearchInstanceType: ").append(this.searchInstanceType()).append(",");
        }
        if (this.searchPartitionCount() != null) {
            sb.append("SearchPartitionCount: ").append(this.searchPartitionCount()).append(",");
        }
        if (this.searchInstanceCount() != null) {
            sb.append("SearchInstanceCount: ").append(this.searchInstanceCount()).append(",");
        }
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String domainName;
        private String arn;
        private Boolean created;
        private Boolean deleted;
        private ServiceEndpoint docService;
        private ServiceEndpoint searchService;
        private Boolean requiresIndexDocuments;
        private Boolean processing;
        private String searchInstanceType;
        private Integer searchPartitionCount;
        private Integer searchInstanceCount;
        private Limits limits;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStatus model) {
            this.setDomainId(model.domainId);
            this.setDomainName(model.domainName);
            this.setARN(model.arn);
            this.setCreated(model.created);
            this.setDeleted(model.deleted);
            this.setDocService(model.docService);
            this.setSearchService(model.searchService);
            this.setRequiresIndexDocuments(model.requiresIndexDocuments);
            this.setProcessing(model.processing);
            this.setSearchInstanceType(model.searchInstanceType);
            this.setSearchPartitionCount(model.searchPartitionCount);
            this.setSearchInstanceCount(model.searchInstanceCount);
            this.setLimits(model.limits);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getARN() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setARN(String arn) {
            this.arn = arn;
        }

        public final Boolean getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Boolean created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Boolean created) {
            this.created = created;
        }

        public final Boolean getDeleted() {
            return this.deleted;
        }

        @Override
        public final Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public final ServiceEndpoint getDocService() {
            return this.docService;
        }

        @Override
        public final Builder docService(ServiceEndpoint docService) {
            this.docService = docService;
            return this;
        }

        public final void setDocService(ServiceEndpoint docService) {
            this.docService = docService;
        }

        public final ServiceEndpoint getSearchService() {
            return this.searchService;
        }

        @Override
        public final Builder searchService(ServiceEndpoint searchService) {
            this.searchService = searchService;
            return this;
        }

        public final void setSearchService(ServiceEndpoint searchService) {
            this.searchService = searchService;
        }

        public final Boolean getRequiresIndexDocuments() {
            return this.requiresIndexDocuments;
        }

        @Override
        public final Builder requiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
            return this;
        }

        public final void setRequiresIndexDocuments(Boolean requiresIndexDocuments) {
            this.requiresIndexDocuments = requiresIndexDocuments;
        }

        public final Boolean getProcessing() {
            return this.processing;
        }

        @Override
        public final Builder processing(Boolean processing) {
            this.processing = processing;
            return this;
        }

        public final void setProcessing(Boolean processing) {
            this.processing = processing;
        }

        public final String getSearchInstanceType() {
            return this.searchInstanceType;
        }

        @Override
        public final Builder searchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
            return this;
        }

        public final void setSearchInstanceType(String searchInstanceType) {
            this.searchInstanceType = searchInstanceType;
        }

        public final Integer getSearchPartitionCount() {
            return this.searchPartitionCount;
        }

        @Override
        public final Builder searchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
            return this;
        }

        public final void setSearchPartitionCount(Integer searchPartitionCount) {
            this.searchPartitionCount = searchPartitionCount;
        }

        public final Integer getSearchInstanceCount() {
            return this.searchInstanceCount;
        }

        @Override
        public final Builder searchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
            return this;
        }

        public final void setSearchInstanceCount(Integer searchInstanceCount) {
            this.searchInstanceCount = searchInstanceCount;
        }

        public final Limits getLimits() {
            return this.limits;
        }

        @Override
        public final Builder limits(Limits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(Limits limits) {
            this.limits = limits;
        }

        public DomainStatus build() {
            return new DomainStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainStatus> {
        public Builder domainId(String var1);

        public Builder domainName(String var1);

        public Builder arn(String var1);

        public Builder created(Boolean var1);

        public Builder deleted(Boolean var1);

        public Builder docService(ServiceEndpoint var1);

        public Builder searchService(ServiceEndpoint var1);

        public Builder requiresIndexDocuments(Boolean var1);

        public Builder processing(Boolean var1);

        public Builder searchInstanceType(String var1);

        public Builder searchPartitionCount(Integer var1);

        public Builder searchInstanceCount(Integer var1);

        public Builder limits(Limits var1);
    }
}

