/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupState;
import software.amazon.awssdk.services.cloudhsmv2.model.ClusterMode;
import software.amazon.awssdk.services.cloudhsmv2.model.Tag;
import software.amazon.awssdk.services.cloudhsmv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Backup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Backup> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupId").getter(Backup.getter(Backup::backupId)).setter(Backup.setter(Builder::backupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()}).build();
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupArn").getter(Backup.getter(Backup::backupArn)).setter(Backup.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BACKUP_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupState").getter(Backup.getter(Backup::backupStateAsString)).setter(Backup.setter(Builder::backupState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupState").build()}).build();
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(Backup.getter(Backup::clusterId)).setter(Backup.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<Instant> CREATE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTimestamp").getter(Backup.getter(Backup::createTimestamp)).setter(Backup.setter(Builder::createTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTimestamp").build()}).build();
    private static final SdkField<Instant> COPY_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CopyTimestamp").getter(Backup.getter(Backup::copyTimestamp)).setter(Backup.setter(Builder::copyTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTimestamp").build()}).build();
    private static final SdkField<Boolean> NEVER_EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("NeverExpires").getter(Backup.getter(Backup::neverExpires)).setter(Backup.setter(Builder::neverExpires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeverExpires").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(Backup.getter(Backup::sourceRegion)).setter(Backup.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackup").getter(Backup.getter(Backup::sourceBackup)).setter(Backup.setter(Builder::sourceBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackup").build()}).build();
    private static final SdkField<String> SOURCE_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceCluster").getter(Backup.getter(Backup::sourceCluster)).setter(Backup.setter(Builder::sourceCluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCluster").build()}).build();
    private static final SdkField<Instant> DELETE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTimestamp").getter(Backup.getter(Backup::deleteTimestamp)).setter(Backup.setter(Builder::deleteTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTimestamp").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(Backup.getter(Backup::tagList)).setter(Backup.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HSM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmType").getter(Backup.getter(Backup::hsmType)).setter(Backup.setter(Builder::hsmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmType").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(Backup.getter(Backup::modeAsString)).setter(Backup.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD, BACKUP_ARN_FIELD, BACKUP_STATE_FIELD, CLUSTER_ID_FIELD, CREATE_TIMESTAMP_FIELD, COPY_TIMESTAMP_FIELD, NEVER_EXPIRES_FIELD, SOURCE_REGION_FIELD, SOURCE_BACKUP_FIELD, SOURCE_CLUSTER_FIELD, DELETE_TIMESTAMP_FIELD, TAG_LIST_FIELD, HSM_TYPE_FIELD, MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Backup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backupId;
    private final String backupArn;
    private final String backupState;
    private final String clusterId;
    private final Instant createTimestamp;
    private final Instant copyTimestamp;
    private final Boolean neverExpires;
    private final String sourceRegion;
    private final String sourceBackup;
    private final String sourceCluster;
    private final Instant deleteTimestamp;
    private final List<Tag> tagList;
    private final String hsmType;
    private final String mode;

    private Backup(BuilderImpl builder) {
        this.backupId = builder.backupId;
        this.backupArn = builder.backupArn;
        this.backupState = builder.backupState;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.copyTimestamp = builder.copyTimestamp;
        this.neverExpires = builder.neverExpires;
        this.sourceRegion = builder.sourceRegion;
        this.sourceBackup = builder.sourceBackup;
        this.sourceCluster = builder.sourceCluster;
        this.deleteTimestamp = builder.deleteTimestamp;
        this.tagList = builder.tagList;
        this.hsmType = builder.hsmType;
        this.mode = builder.mode;
    }

    public final String backupId() {
        return this.backupId;
    }

    public final String backupArn() {
        return this.backupArn;
    }

    public final BackupState backupState() {
        return BackupState.fromValue(this.backupState);
    }

    public final String backupStateAsString() {
        return this.backupState;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final Instant createTimestamp() {
        return this.createTimestamp;
    }

    public final Instant copyTimestamp() {
        return this.copyTimestamp;
    }

    public final Boolean neverExpires() {
        return this.neverExpires;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    public final String sourceBackup() {
        return this.sourceBackup;
    }

    public final String sourceCluster() {
        return this.sourceCluster;
    }

    public final Instant deleteTimestamp() {
        return this.deleteTimestamp;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public final String hsmType() {
        return this.hsmType;
    }

    public final ClusterMode mode() {
        return ClusterMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.neverExpires());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        return Objects.equals(this.backupId(), other.backupId()) && Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.backupStateAsString(), other.backupStateAsString()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.copyTimestamp(), other.copyTimestamp()) && Objects.equals(this.neverExpires(), other.neverExpires()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.sourceBackup(), other.sourceBackup()) && Objects.equals(this.sourceCluster(), other.sourceCluster()) && Objects.equals(this.deleteTimestamp(), other.deleteTimestamp()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.modeAsString(), other.modeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Backup").add("BackupId", (Object)this.backupId()).add("BackupArn", (Object)this.backupArn()).add("BackupState", (Object)this.backupStateAsString()).add("ClusterId", (Object)this.clusterId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("CopyTimestamp", (Object)this.copyTimestamp()).add("NeverExpires", (Object)this.neverExpires()).add("SourceRegion", (Object)this.sourceRegion()).add("SourceBackup", (Object)this.sourceBackup()).add("SourceCluster", (Object)this.sourceCluster()).add("DeleteTimestamp", (Object)this.deleteTimestamp()).add("TagList", this.hasTagList() ? this.tagList() : null).add("HsmType", (Object)this.hsmType()).add("Mode", (Object)this.modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupId": {
                return Optional.ofNullable(clazz.cast(this.backupId()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BackupState": {
                return Optional.ofNullable(clazz.cast(this.backupStateAsString()));
            }
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "CreateTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createTimestamp()));
            }
            case "CopyTimestamp": {
                return Optional.ofNullable(clazz.cast(this.copyTimestamp()));
            }
            case "NeverExpires": {
                return Optional.ofNullable(clazz.cast(this.neverExpires()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "SourceBackup": {
                return Optional.ofNullable(clazz.cast(this.sourceBackup()));
            }
            case "SourceCluster": {
                return Optional.ofNullable(clazz.cast(this.sourceCluster()));
            }
            case "DeleteTimestamp": {
                return Optional.ofNullable(clazz.cast(this.deleteTimestamp()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
            case "HsmType": {
                return Optional.ofNullable(clazz.cast(this.hsmType()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("BackupArn", BACKUP_ARN_FIELD);
        map.put("BackupState", BACKUP_STATE_FIELD);
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("CreateTimestamp", CREATE_TIMESTAMP_FIELD);
        map.put("CopyTimestamp", COPY_TIMESTAMP_FIELD);
        map.put("NeverExpires", NEVER_EXPIRES_FIELD);
        map.put("SourceRegion", SOURCE_REGION_FIELD);
        map.put("SourceBackup", SOURCE_BACKUP_FIELD);
        map.put("SourceCluster", SOURCE_CLUSTER_FIELD);
        map.put("DeleteTimestamp", DELETE_TIMESTAMP_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        map.put("HsmType", HSM_TYPE_FIELD);
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Backup, T> g) {
        return obj -> g.apply((Backup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupId;
        private String backupArn;
        private String backupState;
        private String clusterId;
        private Instant createTimestamp;
        private Instant copyTimestamp;
        private Boolean neverExpires;
        private String sourceRegion;
        private String sourceBackup;
        private String sourceCluster;
        private Instant deleteTimestamp;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();
        private String hsmType;
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(Backup model) {
            this.backupId(model.backupId);
            this.backupArn(model.backupArn);
            this.backupState(model.backupState);
            this.clusterId(model.clusterId);
            this.createTimestamp(model.createTimestamp);
            this.copyTimestamp(model.copyTimestamp);
            this.neverExpires(model.neverExpires);
            this.sourceRegion(model.sourceRegion);
            this.sourceBackup(model.sourceBackup);
            this.sourceCluster(model.sourceCluster);
            this.deleteTimestamp(model.deleteTimestamp);
            this.tagList(model.tagList);
            this.hsmType(model.hsmType);
            this.mode(model.mode);
        }

        public final String getBackupId() {
            return this.backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final String getBackupState() {
            return this.backupState;
        }

        public final void setBackupState(String backupState) {
            this.backupState = backupState;
        }

        @Override
        public final Builder backupState(String backupState) {
            this.backupState = backupState;
            return this;
        }

        @Override
        public final Builder backupState(BackupState backupState) {
            this.backupState(backupState == null ? null : backupState.toString());
            return this;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final Instant getCopyTimestamp() {
            return this.copyTimestamp;
        }

        public final void setCopyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
        }

        @Override
        public final Builder copyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
            return this;
        }

        public final Boolean getNeverExpires() {
            return this.neverExpires;
        }

        public final void setNeverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
        }

        @Override
        public final Builder neverExpires(Boolean neverExpires) {
            this.neverExpires = neverExpires;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceBackup() {
            return this.sourceBackup;
        }

        public final void setSourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
        }

        @Override
        public final Builder sourceBackup(String sourceBackup) {
            this.sourceBackup = sourceBackup;
            return this;
        }

        public final String getSourceCluster() {
            return this.sourceCluster;
        }

        public final void setSourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
        }

        @Override
        public final Builder sourceCluster(String sourceCluster) {
            this.sourceCluster = sourceCluster;
            return this;
        }

        public final Instant getDeleteTimestamp() {
            return this.deleteTimestamp;
        }

        public final void setDeleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
        }

        @Override
        public final Builder deleteTimestamp(Instant deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public Backup build() {
            return new Backup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Backup> {
        public Builder backupId(String var1);

        public Builder backupArn(String var1);

        public Builder backupState(String var1);

        public Builder backupState(BackupState var1);

        public Builder clusterId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder copyTimestamp(Instant var1);

        public Builder neverExpires(Boolean var1);

        public Builder sourceRegion(String var1);

        public Builder sourceBackup(String var1);

        public Builder sourceCluster(String var1);

        public Builder deleteTimestamp(Instant var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);

        public Builder hsmType(String var1);

        public Builder mode(String var1);

        public Builder mode(ClusterMode var1);
    }
}

