/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Response;
import software.amazon.awssdk.services.cloudhsmv2.model.Cluster;
import software.amazon.awssdk.services.cloudhsmv2.model.ClustersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClustersResponse
extends CloudHsmV2Response
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private static final SdkField<List<Cluster>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Clusters").getter(DescribeClustersResponse.getter(DescribeClustersResponse::clusters)).setter(DescribeClustersResponse.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Cluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClustersResponse.getter(DescribeClustersResponse::nextToken)).setter(DescribeClustersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClustersResponse.memberNameToFieldInitializer();
    private final List<Cluster> clusters;
    private final String nextToken;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.clusters = builder.clusters;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<Cluster> clusters() {
        return this.clusters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        return this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClustersResponse").add("Clusters", this.hasClusters() ? this.clusters() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Clusters", CLUSTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClustersResponse, T> g) {
        return obj -> g.apply((DescribeClustersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Response.BuilderImpl
    implements Builder {
        private List<Cluster> clusters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            super(model);
            this.clusters(model.clusters);
            this.nextToken(model.nextToken);
        }

        public final List<Cluster.Builder> getClusters() {
            List<Cluster.Builder> result = ClustersCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClustersCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<Cluster.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (Cluster)((Cluster.Builder)Cluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudHsmV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);

        public Builder clusters(Consumer<Cluster.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

