/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BackupState {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    READY("READY"),
    DELETED("DELETED"),
    PENDING_DELETION("PENDING_DELETION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BackupState> VALUE_MAP;
    private final String value;

    private BackupState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BackupState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BackupState> knownValues() {
        EnumSet<BackupState> knownValues = EnumSet.allOf(BackupState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BackupState.class, BackupState::toString);
    }
}

