/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2BaseClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2Client;
import software.amazon.awssdk.services.cloudhsmv2.endpoints.CloudHsmV2EndpointProvider;

@SdkInternalApi
final class DefaultCloudHsmV2ClientBuilder
extends DefaultCloudHsmV2BaseClientBuilder<CloudHsmV2ClientBuilder, CloudHsmV2Client>
implements CloudHsmV2ClientBuilder {
    DefaultCloudHsmV2ClientBuilder() {
    }

    @Override
    public DefaultCloudHsmV2ClientBuilder endpointProvider(CloudHsmV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudHsmV2Client buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudHsmV2ClientBuilder.validateClientOptions(clientConfiguration);
        CloudHsmV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudHsmV2Client client = new DefaultCloudHsmV2Client(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudHsmV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudHsmV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

