/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2AsyncClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.CloudHsmV2ServiceClientConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.DefaultCloudHsmV2BaseClientBuilder;
import software.amazon.awssdk.services.cloudhsmv2.endpoints.CloudHsmV2EndpointProvider;

@SdkInternalApi
final class DefaultCloudHsmV2AsyncClientBuilder
extends DefaultCloudHsmV2BaseClientBuilder<CloudHsmV2AsyncClientBuilder, CloudHsmV2AsyncClient>
implements CloudHsmV2AsyncClientBuilder {
    DefaultCloudHsmV2AsyncClientBuilder() {
    }

    @Override
    public DefaultCloudHsmV2AsyncClientBuilder endpointProvider(CloudHsmV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudHsmV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudHsmV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        CloudHsmV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCloudHsmV2AsyncClient client = new DefaultCloudHsmV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CloudHsmV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CloudHsmV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

