/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterState {
    CREATE_IN_PROGRESS("CREATE_IN_PROGRESS"),
    UNINITIALIZED("UNINITIALIZED"),
    INITIALIZE_IN_PROGRESS("INITIALIZE_IN_PROGRESS"),
    INITIALIZED("INITIALIZED"),
    ACTIVE("ACTIVE"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETED("DELETED"),
    DEGRADED("DEGRADED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterState> VALUE_MAP;
    private final String value;

    private ClusterState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterState> knownValues() {
        EnumSet<ClusterState> knownValues = EnumSet.allOf(ClusterState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterState.class, ClusterState::toString);
    }
}

