/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteHsmResponse
extends CloudHsmV2Response
implements ToCopyableBuilder<Builder, DeleteHsmResponse> {
    private static final SdkField<String> HSM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteHsmResponse.getter(DeleteHsmResponse::hsmId)).setter(DeleteHsmResponse.setter(Builder::hsmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_ID_FIELD));
    private final String hsmId;

    private DeleteHsmResponse(BuilderImpl builder) {
        super(builder);
        this.hsmId = builder.hsmId;
    }

    public String hsmId() {
        return this.hsmId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmResponse)) {
            return false;
        }
        DeleteHsmResponse other = (DeleteHsmResponse)((Object)obj);
        return Objects.equals(this.hsmId(), other.hsmId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteHsmResponse").add("HsmId", (Object)this.hsmId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmId": {
                return Optional.ofNullable(clazz.cast(this.hsmId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHsmResponse, T> g) {
        return obj -> g.apply((DeleteHsmResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmV2Response.BuilderImpl
    implements Builder {
        private String hsmId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmResponse model) {
            super(model);
            this.hsmId(model.hsmId);
        }

        public final String getHsmId() {
            return this.hsmId;
        }

        @Override
        public final Builder hsmId(String hsmId) {
            this.hsmId = hsmId;
            return this;
        }

        public final void setHsmId(String hsmId) {
            this.hsmId = hsmId;
        }

        @Override
        public DeleteHsmResponse build() {
            return new DeleteHsmResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteHsmResponse> {
        public Builder hsmId(String var1);
    }
}

