/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;

public class DescribeClustersIterable
implements SdkIterable<DescribeClustersResponse> {
    private final CloudHSMV2Client client;
    private final DescribeClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClustersIterable(CloudHSMV2Client client, DescribeClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public Iterator<DescribeClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final DescribeClustersIterable resume(DescribeClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClustersIterable(this.client, (DescribeClustersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeClustersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClustersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClustersResponseFetcher
    implements SyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeClustersResponse nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersIterable.this.client.describeClusters(DescribeClustersIterable.this.firstRequest);
            }
            return DescribeClustersIterable.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

