/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2AsyncClient;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;

public class DescribeBackupsPublisher
implements SdkPublisher<DescribeBackupsResponse> {
    private final CloudHSMV2AsyncClient client;
    private final DescribeBackupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeBackupsPublisher(CloudHSMV2AsyncClient client, DescribeBackupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeBackupsPublisher(CloudHSMV2AsyncClient client, DescribeBackupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeBackupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final DescribeBackupsPublisher resume(DescribeBackupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeBackupsPublisher(this.client, (DescribeBackupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeBackupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeBackupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeBackupsResponseFetcher
    implements AsyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeBackupsResponse> nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsPublisher.this.client.describeBackups(DescribeBackupsPublisher.this.firstRequest);
            }
            return DescribeBackupsPublisher.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

