/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;

public class DescribeBackupsIterable
implements SdkIterable<DescribeBackupsResponse> {
    private final CloudHSMV2Client client;
    private final DescribeBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBackupsIterable(CloudHSMV2Client client, DescribeBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public Iterator<DescribeBackupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final DescribeBackupsIterable resume(DescribeBackupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeBackupsIterable(this.client, (DescribeBackupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeBackupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeBackupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeBackupsResponseFetcher
    implements SyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeBackupsResponse nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsIterable.this.client.describeBackups(DescribeBackupsIterable.this.firstRequest);
            }
            return DescribeBackupsIterable.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

