/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHSMV2Exception;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmAccessDeniedException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInternalFailureException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmInvalidRequestException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmResourceNotFoundException;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeBackupsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudhsmv2.paginators.DescribeBackupsIterable;
import software.amazon.awssdk.services.cloudhsmv2.paginators.DescribeClustersIterable;
import software.amazon.awssdk.services.cloudhsmv2.paginators.ListTagsIterable;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateClusterResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.CreateHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteClusterResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DeleteHsmResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeBackupsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeBackupsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeClustersRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.DescribeClustersResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.InitializeClusterRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.InitializeClusterResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.ListTagsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.UntagResourceResponseUnmarshaller;

@SdkInternalApi
final class DefaultCloudHSMV2Client
implements CloudHSMV2Client {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultCloudHSMV2Client(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    public final String serviceName() {
        return "cloudhsm";
    }

    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateClusterResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMarshaller((Marshaller)new CreateClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateHsmResponse createHsm(CreateHsmRequest createHsmRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmResourceNotFoundException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHsmRequest).withMarshaller((Marshaller)new CreateHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteClusterResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterRequest).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteHsmResponse deleteHsm(DeleteHsmRequest deleteHsmRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHsmResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHsmRequest).withMarshaller((Marshaller)new DeleteHsmRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeBackupsResponse describeBackups(DescribeBackupsRequest describeBackupsRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBackupsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeBackupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeBackupsRequest).withMarshaller((Marshaller)new DescribeBackupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeBackupsIterable describeBackupsPaginator(DescribeBackupsRequest describeBackupsRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        return new DescribeBackupsIterable(this, describeBackupsRequest);
    }

    @Override
    public DescribeClustersResponse describeClusters(DescribeClustersRequest describeClustersRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeClustersResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DescribeClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeClustersRequest).withMarshaller((Marshaller)new DescribeClustersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeClustersIterable describeClustersPaginator(DescribeClustersRequest describeClustersRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        return new DescribeClustersIterable(this, describeClustersRequest);
    }

    @Override
    public InitializeClusterResponse initializeCluster(InitializeClusterRequest initializeClusterRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitializeClusterResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (InitializeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initializeClusterRequest).withMarshaller((Marshaller)new InitializeClusterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (ListTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsRequest).withMarshaller((Marshaller)new ListTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListTagsIterable listTagsPaginator(ListTagsRequest listTagsRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        return new ListTagsIterable(this, listTagsRequest);
    }

    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws CloudHsmInternalFailureException, CloudHsmServiceException, CloudHsmResourceNotFoundException, CloudHsmInvalidRequestException, CloudHsmAccessDeniedException, SdkServiceException, SdkClientException, CloudHSMV2Exception {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResponseUnmarshaller());
        HttpResponseHandler<SdkServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<SdkServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(CloudHSMV2Exception.class).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInternalFailureException").withModeledClass(CloudHsmInternalFailureException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmServiceException").withModeledClass(CloudHsmServiceException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmAccessDeniedException").withModeledClass(CloudHsmAccessDeniedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmResourceNotFoundException").withModeledClass(CloudHsmResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("CloudHsmInvalidRequestException").withModeledClass(CloudHsmInvalidRequestException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

