/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Cluster;
import software.amazon.awssdk.services.cloudhsmv2.transform.CertificatesUnmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.transform.HsmUnmarshaller;

public class ClusterUnmarshaller
implements Unmarshaller<Cluster, JsonUnmarshallerContext> {
    private static final ClusterUnmarshaller INSTANCE = new ClusterUnmarshaller();

    public Cluster unmarshall(JsonUnmarshallerContext context) throws Exception {
        Cluster.Builder clusterBuilder = Cluster.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BackupPolicy", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.backupPolicy((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.clusterId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CreateTimestamp", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.createTimestamp((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("Hsms", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.hsms(new ListUnmarshaller((Unmarshaller)HsmUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("HsmType", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.hsmType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PreCoPassword", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.preCoPassword((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SecurityGroup", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.securityGroup((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SourceBackupId", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.sourceBackupId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StateMessage", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.stateMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubnetMapping", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.subnetMapping(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("VpcId", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.vpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Certificates", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.certificates(CertificatesUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Cluster)clusterBuilder.build();
    }

    public static ClusterUnmarshaller getInstance() {
        return INSTANCE;
    }
}

