/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Hsm;

public class HsmUnmarshaller
implements Unmarshaller<Hsm, JsonUnmarshallerContext> {
    private static final HsmUnmarshaller INSTANCE = new HsmUnmarshaller();

    public Hsm unmarshall(JsonUnmarshallerContext context) throws Exception {
        Hsm.Builder hsmBuilder = Hsm.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.availabilityZone((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterId", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.clusterId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.subnetId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EniId", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.eniId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EniIp", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.eniIp((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HsmId", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.hsmId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("State", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.state((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StateMessage", targetDepth)) {
                    context.nextToken();
                    hsmBuilder.stateMessage((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Hsm)hsmBuilder.build();
    }

    public static HsmUnmarshaller getInstance() {
        return INSTANCE;
    }
}

