/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.CreateHsmRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateHsmRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").isBinary(false).build();
    private static final MarshallingInfo<String> IPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IpAddress").isBinary(false).build();
    private static final CreateHsmRequestModelMarshaller INSTANCE = new CreateHsmRequestModelMarshaller();

    private CreateHsmRequestModelMarshaller() {
    }

    public static CreateHsmRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateHsmRequest createHsmRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createHsmRequest), (String)"createHsmRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createHsmRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.ipAddress(), IPADDRESS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

