/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.ListTagsResponse;

public class ListTagsIterable
implements SdkIterable<ListTagsResponse> {
    private final CloudHSMV2Client client;
    private final ListTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsIterable(CloudHSMV2Client client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListTagsIterable resume(ListTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagsIterable(this.client, (ListTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTagsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTagsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTagsResponseFetcher
    implements SyncPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsIterable.this.client.listTags(ListTagsIterable.this.firstRequest);
            }
            return ListTagsIterable.this.client.listTags((ListTagsRequest)((Object)ListTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

