/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.model.BackupPolicy;
import software.amazon.awssdk.services.cloudhsmv2.model.Certificates;
import software.amazon.awssdk.services.cloudhsmv2.model.ClusterState;
import software.amazon.awssdk.services.cloudhsmv2.model.ExternalSubnetMappingCopier;
import software.amazon.awssdk.services.cloudhsmv2.model.Hsm;
import software.amazon.awssdk.services.cloudhsmv2.model.HsmsCopier;
import software.amazon.awssdk.services.cloudhsmv2.transform.ClusterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Cluster
implements StructuredPojo,
ToCopyableBuilder<Builder, Cluster> {
    private final String backupPolicy;
    private final String clusterId;
    private final Instant createTimestamp;
    private final List<Hsm> hsms;
    private final String hsmType;
    private final String preCoPassword;
    private final String securityGroup;
    private final String sourceBackupId;
    private final String state;
    private final String stateMessage;
    private final Map<String, String> subnetMapping;
    private final String vpcId;
    private final Certificates certificates;

    private Cluster(BuilderImpl builder) {
        this.backupPolicy = builder.backupPolicy;
        this.clusterId = builder.clusterId;
        this.createTimestamp = builder.createTimestamp;
        this.hsms = builder.hsms;
        this.hsmType = builder.hsmType;
        this.preCoPassword = builder.preCoPassword;
        this.securityGroup = builder.securityGroup;
        this.sourceBackupId = builder.sourceBackupId;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.subnetMapping = builder.subnetMapping;
        this.vpcId = builder.vpcId;
        this.certificates = builder.certificates;
    }

    public BackupPolicy backupPolicy() {
        return BackupPolicy.fromValue(this.backupPolicy);
    }

    public String backupPolicyString() {
        return this.backupPolicy;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Instant createTimestamp() {
        return this.createTimestamp;
    }

    public List<Hsm> hsms() {
        return this.hsms;
    }

    public String hsmType() {
        return this.hsmType;
    }

    public String preCoPassword() {
        return this.preCoPassword;
    }

    public String securityGroup() {
        return this.securityGroup;
    }

    public String sourceBackupId() {
        return this.sourceBackupId;
    }

    public ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public Map<String, String> subnetMapping() {
        return this.subnetMapping;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Certificates certificates() {
        return this.certificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPolicyString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsms());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmType());
        hashCode = 31 * hashCode + Objects.hashCode(this.preCoPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.backupPolicyString(), other.backupPolicyString()) && Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.createTimestamp(), other.createTimestamp()) && Objects.equals(this.hsms(), other.hsms()) && Objects.equals(this.hsmType(), other.hsmType()) && Objects.equals(this.preCoPassword(), other.preCoPassword()) && Objects.equals(this.securityGroup(), other.securityGroup()) && Objects.equals(this.sourceBackupId(), other.sourceBackupId()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.subnetMapping(), other.subnetMapping()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.certificates(), other.certificates());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("BackupPolicy", (Object)this.backupPolicyString()).add("ClusterId", (Object)this.clusterId()).add("CreateTimestamp", (Object)this.createTimestamp()).add("Hsms", this.hsms()).add("HsmType", (Object)this.hsmType()).add("PreCoPassword", (Object)this.preCoPassword()).add("SecurityGroup", (Object)this.securityGroup()).add("SourceBackupId", (Object)this.sourceBackupId()).add("State", (Object)this.stateString()).add("StateMessage", (Object)this.stateMessage()).add("SubnetMapping", this.subnetMapping()).add("VpcId", (Object)this.vpcId()).add("Certificates", (Object)this.certificates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPolicy": {
                return Optional.of(clazz.cast(this.backupPolicyString()));
            }
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "CreateTimestamp": {
                return Optional.of(clazz.cast(this.createTimestamp()));
            }
            case "Hsms": {
                return Optional.of(clazz.cast(this.hsms()));
            }
            case "HsmType": {
                return Optional.of(clazz.cast(this.hsmType()));
            }
            case "PreCoPassword": {
                return Optional.of(clazz.cast(this.preCoPassword()));
            }
            case "SecurityGroup": {
                return Optional.of(clazz.cast(this.securityGroup()));
            }
            case "SourceBackupId": {
                return Optional.of(clazz.cast(this.sourceBackupId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateMessage": {
                return Optional.of(clazz.cast(this.stateMessage()));
            }
            case "SubnetMapping": {
                return Optional.of(clazz.cast(this.subnetMapping()));
            }
            case "VpcId": {
                return Optional.of(clazz.cast(this.vpcId()));
            }
            case "Certificates": {
                return Optional.of(clazz.cast(this.certificates()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPolicy;
        private String clusterId;
        private Instant createTimestamp;
        private List<Hsm> hsms;
        private String hsmType;
        private String preCoPassword;
        private String securityGroup;
        private String sourceBackupId;
        private String state;
        private String stateMessage;
        private Map<String, String> subnetMapping;
        private String vpcId;
        private Certificates certificates;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.backupPolicy(model.backupPolicy);
            this.clusterId(model.clusterId);
            this.createTimestamp(model.createTimestamp);
            this.hsms(model.hsms);
            this.hsmType(model.hsmType);
            this.preCoPassword(model.preCoPassword);
            this.securityGroup(model.securityGroup);
            this.sourceBackupId(model.sourceBackupId);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.subnetMapping(model.subnetMapping);
            this.vpcId(model.vpcId);
            this.certificates(model.certificates);
        }

        public final String getBackupPolicy() {
            return this.backupPolicy;
        }

        @Override
        public final Builder backupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
            return this;
        }

        @Override
        public final Builder backupPolicy(BackupPolicy backupPolicy) {
            this.backupPolicy(backupPolicy.toString());
            return this;
        }

        public final void setBackupPolicy(String backupPolicy) {
            this.backupPolicy = backupPolicy;
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Instant getCreateTimestamp() {
            return this.createTimestamp;
        }

        @Override
        public final Builder createTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public final void setCreateTimestamp(Instant createTimestamp) {
            this.createTimestamp = createTimestamp;
        }

        public final Collection<Hsm.Builder> getHsms() {
            return this.hsms != null ? (Collection)this.hsms.stream().map(Hsm::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsms(Collection<Hsm> hsms) {
            this.hsms = HsmsCopier.copy(hsms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsms(Hsm ... hsms) {
            this.hsms(Arrays.asList(hsms));
            return this;
        }

        public final void setHsms(Collection<Hsm.BuilderImpl> hsms) {
            this.hsms = HsmsCopier.copyFromBuilder(hsms);
        }

        public final String getHsmType() {
            return this.hsmType;
        }

        @Override
        public final Builder hsmType(String hsmType) {
            this.hsmType = hsmType;
            return this;
        }

        public final void setHsmType(String hsmType) {
            this.hsmType = hsmType;
        }

        public final String getPreCoPassword() {
            return this.preCoPassword;
        }

        @Override
        public final Builder preCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
            return this;
        }

        public final void setPreCoPassword(String preCoPassword) {
            this.preCoPassword = preCoPassword;
        }

        public final String getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final Builder securityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public final void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public final String getSourceBackupId() {
            return this.sourceBackupId;
        }

        @Override
        public final Builder sourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
            return this;
        }

        public final void setSourceBackupId(String sourceBackupId) {
            this.sourceBackupId = sourceBackupId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final Map<String, String> getSubnetMapping() {
            return this.subnetMapping;
        }

        @Override
        public final Builder subnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
            return this;
        }

        public final void setSubnetMapping(Map<String, String> subnetMapping) {
            this.subnetMapping = ExternalSubnetMappingCopier.copy(subnetMapping);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Certificates.Builder getCertificates() {
            return this.certificates != null ? this.certificates.toBuilder() : null;
        }

        @Override
        public final Builder certificates(Certificates certificates) {
            this.certificates = certificates;
            return this;
        }

        public final void setCertificates(Certificates.BuilderImpl certificates) {
            this.certificates = certificates != null ? certificates.build() : null;
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder backupPolicy(String var1);

        public Builder backupPolicy(BackupPolicy var1);

        public Builder clusterId(String var1);

        public Builder createTimestamp(Instant var1);

        public Builder hsms(Collection<Hsm> var1);

        public Builder hsms(Hsm ... var1);

        public Builder hsmType(String var1);

        public Builder preCoPassword(String var1);

        public Builder securityGroup(String var1);

        public Builder sourceBackupId(String var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateMessage(String var1);

        public Builder subnetMapping(Map<String, String> var1);

        public Builder vpcId(String var1);

        public Builder certificates(Certificates var1);

        default public Builder certificates(Consumer<Certificates.Builder> certificates) {
            return this.certificates((Certificates)((Certificates.Builder)Certificates.builder().apply(certificates)).build());
        }
    }
}

