/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Hsm;

@SdkInternalApi
public class HsmMarshaller {
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").build();
    private static final MarshallingInfo<String> ENIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniId").build();
    private static final MarshallingInfo<String> ENIIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniIp").build();
    private static final MarshallingInfo<String> HSMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATEMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateMessage").build();
    private static final HsmMarshaller INSTANCE = new HsmMarshaller();

    public static HsmMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Hsm hsm, ProtocolMarshaller protocolMarshaller) {
        if (hsm == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)hsm.availabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall((Object)hsm.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)hsm.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)hsm.eniId(), ENIID_BINDING);
            protocolMarshaller.marshall((Object)hsm.eniIp(), ENIIP_BINDING);
            protocolMarshaller.marshall((Object)hsm.hsmId(), HSMID_BINDING);
            protocolMarshaller.marshall((Object)hsm.stateString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)hsm.stateMessage(), STATEMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

