/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Certificates;

public class CertificatesUnmarshaller
implements Unmarshaller<Certificates, JsonUnmarshallerContext> {
    private static final CertificatesUnmarshaller INSTANCE = new CertificatesUnmarshaller();

    public Certificates unmarshall(JsonUnmarshallerContext context) throws Exception {
        Certificates.Builder certificatesBuilder = Certificates.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ClusterCsr", targetDepth)) {
                    context.nextToken();
                    certificatesBuilder.clusterCsr((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HsmCertificate", targetDepth)) {
                    context.nextToken();
                    certificatesBuilder.hsmCertificate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("AwsHardwareCertificate", targetDepth)) {
                    context.nextToken();
                    certificatesBuilder.awsHardwareCertificate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ManufacturerHardwareCertificate", targetDepth)) {
                    context.nextToken();
                    certificatesBuilder.manufacturerHardwareCertificate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterCertificate", targetDepth)) {
                    context.nextToken();
                    certificatesBuilder.clusterCertificate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Certificates)certificatesBuilder.build();
    }

    public static CertificatesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

