/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudhsmv2.CloudHSMV2Client;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersRequest;
import software.amazon.awssdk.services.cloudhsmv2.model.DescribeClustersResponse;

public final class DescribeClustersPaginator
implements SdkIterable<DescribeClustersResponse> {
    private final CloudHSMV2Client client;
    private final DescribeClustersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClustersPaginator(CloudHSMV2Client client, DescribeClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public Iterator<DescribeClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class DescribeClustersResponseFetcher
    implements NextPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeClustersResponse nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPaginator.this.client.describeClusters(DescribeClustersPaginator.this.firstRequest);
            }
            return DescribeClustersPaginator.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

