/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.InitializeClusterRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InitializeClusterRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> SIGNEDCERT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignedCert").isBinary(false).build();
    private static final MarshallingInfo<String> TRUSTANCHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TrustAnchor").isBinary(false).build();
    private static final InitializeClusterRequestModelMarshaller INSTANCE = new InitializeClusterRequestModelMarshaller();

    private InitializeClusterRequestModelMarshaller() {
    }

    public static InitializeClusterRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InitializeClusterRequest initializeClusterRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)initializeClusterRequest), (String)"initializeClusterRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)initializeClusterRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)initializeClusterRequest.signedCert(), SIGNEDCERT_BINDING);
            protocolMarshaller.marshall((Object)initializeClusterRequest.trustAnchor(), TRUSTANCHOR_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

