/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsmv2.model.Backup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BackupMarshaller {
    private static final MarshallingInfo<String> BACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupId").isBinary(false).build();
    private static final MarshallingInfo<String> BACKUPSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupState").isBinary(false).build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").isBinary(false).build();
    private static final BackupMarshaller INSTANCE = new BackupMarshaller();

    private BackupMarshaller() {
    }

    public static BackupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Backup backup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)backup, (String)"backup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)backup.backupId(), BACKUPID_BINDING);
            protocolMarshaller.marshall((Object)backup.backupStateAsString(), BACKUPSTATE_BINDING);
            protocolMarshaller.marshall((Object)backup.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)backup.createTimestamp(), CREATETIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

