/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.cloudhsmv2.model.CloudHsmV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InitializeClusterRequest
extends CloudHsmV2Request
implements ToCopyableBuilder<Builder, InitializeClusterRequest> {
    private final String clusterId;
    private final String signedCert;
    private final String trustAnchor;

    private InitializeClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.signedCert = builder.signedCert;
        this.trustAnchor = builder.trustAnchor;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String signedCert() {
        return this.signedCert;
    }

    public String trustAnchor() {
        return this.trustAnchor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.signedCert());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitializeClusterRequest)) {
            return false;
        }
        InitializeClusterRequest other = (InitializeClusterRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.signedCert(), other.signedCert()) && Objects.equals(this.trustAnchor(), other.trustAnchor());
    }

    public String toString() {
        return ToString.builder((String)"InitializeClusterRequest").add("ClusterId", (Object)this.clusterId()).add("SignedCert", (Object)this.signedCert()).add("TrustAnchor", (Object)this.trustAnchor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "SignedCert": {
                return Optional.ofNullable(clazz.cast(this.signedCert()));
            }
            case "TrustAnchor": {
                return Optional.ofNullable(clazz.cast(this.trustAnchor()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHsmV2Request.BuilderImpl
    implements Builder {
        private String clusterId;
        private String signedCert;
        private String trustAnchor;

        private BuilderImpl() {
        }

        private BuilderImpl(InitializeClusterRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.signedCert(model.signedCert);
            this.trustAnchor(model.trustAnchor);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getSignedCert() {
            return this.signedCert;
        }

        @Override
        public final Builder signedCert(String signedCert) {
            this.signedCert = signedCert;
            return this;
        }

        public final void setSignedCert(String signedCert) {
            this.signedCert = signedCert;
        }

        public final String getTrustAnchor() {
            return this.trustAnchor;
        }

        @Override
        public final Builder trustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
            return this;
        }

        public final void setTrustAnchor(String trustAnchor) {
            this.trustAnchor = trustAnchor;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitializeClusterRequest build() {
            return new InitializeClusterRequest(this);
        }
    }

    public static interface Builder
    extends CloudHsmV2Request.Builder,
    CopyableBuilder<Builder, InitializeClusterRequest> {
        public Builder clusterId(String var1);

        public Builder signedCert(String var1);

        public Builder trustAnchor(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

