/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsmv2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudhsmv2.transform.CertificatesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificates
implements StructuredPojo,
ToCopyableBuilder<Builder, Certificates> {
    private final String clusterCsr;
    private final String hsmCertificate;
    private final String awsHardwareCertificate;
    private final String manufacturerHardwareCertificate;
    private final String clusterCertificate;

    private Certificates(BuilderImpl builder) {
        this.clusterCsr = builder.clusterCsr;
        this.hsmCertificate = builder.hsmCertificate;
        this.awsHardwareCertificate = builder.awsHardwareCertificate;
        this.manufacturerHardwareCertificate = builder.manufacturerHardwareCertificate;
        this.clusterCertificate = builder.clusterCertificate;
    }

    public String clusterCsr() {
        return this.clusterCsr;
    }

    public String hsmCertificate() {
        return this.hsmCertificate;
    }

    public String awsHardwareCertificate() {
        return this.awsHardwareCertificate;
    }

    public String manufacturerHardwareCertificate() {
        return this.manufacturerHardwareCertificate;
    }

    public String clusterCertificate() {
        return this.clusterCertificate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCsr());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturerHardwareCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCertificate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificates)) {
            return false;
        }
        Certificates other = (Certificates)obj;
        return Objects.equals(this.clusterCsr(), other.clusterCsr()) && Objects.equals(this.hsmCertificate(), other.hsmCertificate()) && Objects.equals(this.awsHardwareCertificate(), other.awsHardwareCertificate()) && Objects.equals(this.manufacturerHardwareCertificate(), other.manufacturerHardwareCertificate()) && Objects.equals(this.clusterCertificate(), other.clusterCertificate());
    }

    public String toString() {
        return ToString.builder((String)"Certificates").add("ClusterCsr", (Object)this.clusterCsr()).add("HsmCertificate", (Object)this.hsmCertificate()).add("AwsHardwareCertificate", (Object)this.awsHardwareCertificate()).add("ManufacturerHardwareCertificate", (Object)this.manufacturerHardwareCertificate()).add("ClusterCertificate", (Object)this.clusterCertificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterCsr": {
                return Optional.ofNullable(clazz.cast(this.clusterCsr()));
            }
            case "HsmCertificate": {
                return Optional.ofNullable(clazz.cast(this.hsmCertificate()));
            }
            case "AwsHardwareCertificate": {
                return Optional.ofNullable(clazz.cast(this.awsHardwareCertificate()));
            }
            case "ManufacturerHardwareCertificate": {
                return Optional.ofNullable(clazz.cast(this.manufacturerHardwareCertificate()));
            }
            case "ClusterCertificate": {
                return Optional.ofNullable(clazz.cast(this.clusterCertificate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CertificatesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterCsr;
        private String hsmCertificate;
        private String awsHardwareCertificate;
        private String manufacturerHardwareCertificate;
        private String clusterCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificates model) {
            this.clusterCsr(model.clusterCsr);
            this.hsmCertificate(model.hsmCertificate);
            this.awsHardwareCertificate(model.awsHardwareCertificate);
            this.manufacturerHardwareCertificate(model.manufacturerHardwareCertificate);
            this.clusterCertificate(model.clusterCertificate);
        }

        public final String getClusterCsr() {
            return this.clusterCsr;
        }

        @Override
        public final Builder clusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
            return this;
        }

        public final void setClusterCsr(String clusterCsr) {
            this.clusterCsr = clusterCsr;
        }

        public final String getHsmCertificate() {
            return this.hsmCertificate;
        }

        @Override
        public final Builder hsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
            return this;
        }

        public final void setHsmCertificate(String hsmCertificate) {
            this.hsmCertificate = hsmCertificate;
        }

        public final String getAwsHardwareCertificate() {
            return this.awsHardwareCertificate;
        }

        @Override
        public final Builder awsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
            return this;
        }

        public final void setAwsHardwareCertificate(String awsHardwareCertificate) {
            this.awsHardwareCertificate = awsHardwareCertificate;
        }

        public final String getManufacturerHardwareCertificate() {
            return this.manufacturerHardwareCertificate;
        }

        @Override
        public final Builder manufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
            return this;
        }

        public final void setManufacturerHardwareCertificate(String manufacturerHardwareCertificate) {
            this.manufacturerHardwareCertificate = manufacturerHardwareCertificate;
        }

        public final String getClusterCertificate() {
            return this.clusterCertificate;
        }

        @Override
        public final Builder clusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
            return this;
        }

        public final void setClusterCertificate(String clusterCertificate) {
            this.clusterCertificate = clusterCertificate;
        }

        public Certificates build() {
            return new Certificates(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Certificates> {
        public Builder clusterCsr(String var1);

        public Builder hsmCertificate(String var1);

        public Builder awsHardwareCertificate(String var1);

        public Builder manufacturerHardwareCertificate(String var1);

        public Builder clusterCertificate(String var1);
    }
}

