/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyLunaClientRequest
extends CloudHsmRequest
implements ToCopyableBuilder<Builder, ModifyLunaClientRequest> {
    private static final SdkField<String> CLIENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientArn").getter(ModifyLunaClientRequest.getter(ModifyLunaClientRequest::clientArn)).setter(ModifyLunaClientRequest.setter(Builder::clientArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(ModifyLunaClientRequest.getter(ModifyLunaClientRequest::certificate)).setter(ModifyLunaClientRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ARN_FIELD, CERTIFICATE_FIELD));
    private final String clientArn;
    private final String certificate;

    private ModifyLunaClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.certificate = builder.certificate;
    }

    public final String clientArn() {
        return this.clientArn;
    }

    public final String certificate() {
        return this.certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLunaClientRequest)) {
            return false;
        }
        ModifyLunaClientRequest other = (ModifyLunaClientRequest)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.certificate(), other.certificate());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyLunaClientRequest").add("ClientArn", (Object)this.clientArn()).add("Certificate", (Object)this.certificate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.ofNullable(clazz.cast(this.clientArn()));
            }
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyLunaClientRequest, T> g) {
        return obj -> g.apply((ModifyLunaClientRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudHsmRequest.BuilderImpl
    implements Builder {
        private String clientArn;
        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLunaClientRequest model) {
            super(model);
            this.clientArn(model.clientArn);
            this.certificate(model.certificate);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyLunaClientRequest build() {
            return new ModifyLunaClientRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudHsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyLunaClientRequest> {
        public Builder clientArn(String var1);

        public Builder certificate(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

