/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudhsm.CloudHsmClient;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmInternalException;
import software.amazon.awssdk.services.cloudhsm.model.CloudHsmServiceException;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.CreateLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DeleteLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.DescribeLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigRequest;
import software.amazon.awssdk.services.cloudhsm.model.GetConfigResponse;
import software.amazon.awssdk.services.cloudhsm.model.InvalidRequestException;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListAvailableZonesResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHapgsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListHsmsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListLunaClientsResponse;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmResponse;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientRequest;
import software.amazon.awssdk.services.cloudhsm.model.ModifyLunaClientResponse;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.cloudhsm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.cloudhsm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.CreateLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DeleteLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.DescribeLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.GetConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListAvailableZonesRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHapgsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListHsmsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListLunaClientsRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHapgRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyHsmRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.ModifyLunaClientRequestMarshaller;
import software.amazon.awssdk.services.cloudhsm.transform.RemoveTagsFromResourceRequestMarshaller;

@SdkInternalApi
final class DefaultCloudHsmClient
implements CloudHsmClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudHsmClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "cloudhsm";
    }

    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsToResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AddTagsToResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTagsToResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsToResourceRequest).withMarshaller((Marshaller)new AddTagsToResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateHapgResponse createHapg(CreateHapgRequest createHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHapgResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHapg").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHapgRequest).withMarshaller((Marshaller)new CreateHapgRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateHsmResponse createHsm(CreateHsmRequest createHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateHsmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHsm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createHsmRequest).withMarshaller((Marshaller)new CreateHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateLunaClientResponse createLunaClient(CreateLunaClientRequest createLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLunaClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLunaClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLunaClientRequest).withMarshaller((Marshaller)new CreateLunaClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteHapgResponse deleteHapg(DeleteHapgRequest deleteHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHapgResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHapg").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHapgRequest).withMarshaller((Marshaller)new DeleteHapgRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteHsmResponse deleteHsm(DeleteHsmRequest deleteHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHsmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHsm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHsmRequest).withMarshaller((Marshaller)new DeleteHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteLunaClientResponse deleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLunaClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLunaClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLunaClientRequest).withMarshaller((Marshaller)new DeleteLunaClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeHapgResponse describeHapg(DescribeHapgRequest describeHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHapgResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHapg").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHapgRequest).withMarshaller((Marshaller)new DescribeHapgRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeHsmResponse describeHsm(DescribeHsmRequest describeHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeHsmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeHsm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeHsmRequest).withMarshaller((Marshaller)new DescribeHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeLunaClientResponse describeLunaClient(DescribeLunaClientRequest describeLunaClientRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLunaClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLunaClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLunaClientRequest).withMarshaller((Marshaller)new DescribeLunaClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetConfigResponse getConfig(GetConfigRequest getConfigRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfig").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getConfigRequest).withMarshaller((Marshaller)new GetConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListAvailableZonesResponse listAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAvailableZonesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListAvailableZonesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAvailableZones").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAvailableZonesRequest).withMarshaller((Marshaller)new ListAvailableZonesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListHapgsResponse listHapgs(ListHapgsRequest listHapgsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHapgsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListHapgsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHapgs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHapgsRequest).withMarshaller((Marshaller)new ListHapgsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListHsmsResponse listHsms(ListHsmsRequest listHsmsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHsmsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListHsmsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHsms").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHsmsRequest).withMarshaller((Marshaller)new ListHsmsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListLunaClientsResponse listLunaClients(ListLunaClientsRequest listLunaClientsRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLunaClientsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListLunaClientsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLunaClients").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listLunaClientsRequest).withMarshaller((Marshaller)new ListLunaClientsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyHapgResponse modifyHapg(ModifyHapgRequest modifyHapgRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyHapgResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyHapgResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyHapg").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyHapgRequest).withMarshaller((Marshaller)new ModifyHapgRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyHsmResponse modifyHsm(ModifyHsmRequest modifyHsmRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyHsmResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyHsmResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyHsm").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyHsmRequest).withMarshaller((Marshaller)new ModifyHsmRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ModifyLunaClientResponse modifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest) throws CloudHsmServiceException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ModifyLunaClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ModifyLunaClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLunaClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLunaClientRequest).withMarshaller((Marshaller)new ModifyLunaClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws CloudHsmServiceException, CloudHsmInternalException, InvalidRequestException, AwsServiceException, SdkClientException, CloudHsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTagsFromResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RemoveTagsFromResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsFromResourceRequest).withMarshaller((Marshaller)new RemoveTagsFromResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudHsmException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmInternalException").exceptionBuilderSupplier(CloudHsmInternalException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CloudHsmServiceException").exceptionBuilderSupplier(CloudHsmServiceException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

