/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHsmRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyHsmRequestModelMarshaller {
    private static final MarshallingInfo<String> HSMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmArn").isBinary(false).build();
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> ENIIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniIp").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<String> SYSLOGIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyslogIp").isBinary(false).build();
    private static final ModifyHsmRequestModelMarshaller INSTANCE = new ModifyHsmRequestModelMarshaller();

    private ModifyHsmRequestModelMarshaller() {
    }

    public static ModifyHsmRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyHsmRequest modifyHsmRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyHsmRequest), (String)"modifyHsmRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyHsmRequest.hsmArn(), HSMARN_BINDING);
            protocolMarshaller.marshall((Object)modifyHsmRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)modifyHsmRequest.eniIp(), ENIIP_BINDING);
            protocolMarshaller.marshall((Object)modifyHsmRequest.iamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)modifyHsmRequest.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)modifyHsmRequest.syslogIp(), SYSLOGIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

