/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyLunaClientRequest
extends CloudHSMRequest
implements ToCopyableBuilder<Builder, ModifyLunaClientRequest> {
    private final String clientArn;
    private final String certificate;

    private ModifyLunaClientRequest(BuilderImpl builder) {
        super(builder);
        this.clientArn = builder.clientArn;
        this.certificate = builder.certificate;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public String certificate() {
        return this.certificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyLunaClientRequest)) {
            return false;
        }
        ModifyLunaClientRequest other = (ModifyLunaClientRequest)((Object)obj);
        return Objects.equals(this.clientArn(), other.clientArn()) && Objects.equals(this.certificate(), other.certificate());
    }

    public String toString() {
        return ToString.builder((String)"ModifyLunaClientRequest").add("ClientArn", (Object)this.clientArn()).add("Certificate", (Object)this.certificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientArn": {
                return Optional.of(clazz.cast(this.clientArn()));
            }
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMRequest.BuilderImpl
    implements Builder {
        private String clientArn;
        private String certificate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyLunaClientRequest model) {
            this.clientArn(model.clientArn);
            this.certificate(model.certificate);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyLunaClientRequest build() {
            return new ModifyLunaClientRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMRequest.Builder,
    CopyableBuilder<Builder, ModifyLunaClientRequest> {
        public Builder clientArn(String var1);

        public Builder certificate(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

