/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudhsm.model.TagKeyListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RemoveTagsFromResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
    private final String resourceArn;
    private final List<String> tagKeyList;

    private RemoveTagsFromResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.tagKeyList = builder.tagKeyList;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<String> tagKeyList() {
        return this.tagKeyList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceArn() == null ? 0 : this.resourceArn().hashCode());
        hashCode = 31 * hashCode + (this.tagKeyList() == null ? 0 : this.tagKeyList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsFromResourceRequest)) {
            return false;
        }
        RemoveTagsFromResourceRequest other = (RemoveTagsFromResourceRequest)((Object)obj);
        if (other.resourceArn() == null ^ this.resourceArn() == null) {
            return false;
        }
        if (other.resourceArn() != null && !other.resourceArn().equals(this.resourceArn())) {
            return false;
        }
        if (other.tagKeyList() == null ^ this.tagKeyList() == null) {
            return false;
        }
        return other.tagKeyList() == null || other.tagKeyList().equals(this.tagKeyList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.tagKeyList() != null) {
            sb.append("TagKeyList: ").append(this.tagKeyList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<String> tagKeyList;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveTagsFromResourceRequest model) {
            this.setResourceArn(model.resourceArn);
            this.setTagKeyList(model.tagKeyList);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<String> getTagKeyList() {
            return this.tagKeyList;
        }

        @Override
        public final Builder tagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeyList(String ... tagKeyList) {
            this.tagKeyList(Arrays.asList(tagKeyList));
            return this;
        }

        public final void setTagKeyList(Collection<String> tagKeyList) {
            this.tagKeyList = TagKeyListCopier.copy(tagKeyList);
        }

        public RemoveTagsFromResourceRequest build() {
            return new RemoveTagsFromResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RemoveTagsFromResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tagKeyList(Collection<String> var1);

        public Builder tagKeyList(String ... var1);
    }
}

