/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudhsm.model.PartitionSerialListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyHapgRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyHapgRequest> {
    private final String hapgArn;
    private final String label;
    private final List<String> partitionSerialList;

    private ModifyHapgRequest(BuilderImpl builder) {
        this.hapgArn = builder.hapgArn;
        this.label = builder.label;
        this.partitionSerialList = builder.partitionSerialList;
    }

    public String hapgArn() {
        return this.hapgArn;
    }

    public String label() {
        return this.label;
    }

    public List<String> partitionSerialList() {
        return this.partitionSerialList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hapgArn() == null ? 0 : this.hapgArn().hashCode());
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.partitionSerialList() == null ? 0 : this.partitionSerialList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHapgRequest)) {
            return false;
        }
        ModifyHapgRequest other = (ModifyHapgRequest)((Object)obj);
        if (other.hapgArn() == null ^ this.hapgArn() == null) {
            return false;
        }
        if (other.hapgArn() != null && !other.hapgArn().equals(this.hapgArn())) {
            return false;
        }
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.partitionSerialList() == null ^ this.partitionSerialList() == null) {
            return false;
        }
        return other.partitionSerialList() == null || other.partitionSerialList().equals(this.partitionSerialList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hapgArn() != null) {
            sb.append("HapgArn: ").append(this.hapgArn()).append(",");
        }
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.partitionSerialList() != null) {
            sb.append("PartitionSerialList: ").append(this.partitionSerialList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hapgArn;
        private String label;
        private List<String> partitionSerialList;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHapgRequest model) {
            this.setHapgArn(model.hapgArn);
            this.setLabel(model.label);
            this.setPartitionSerialList(model.partitionSerialList);
        }

        public final String getHapgArn() {
            return this.hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getPartitionSerialList() {
            return this.partitionSerialList;
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String ... partitionSerialList) {
            this.partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        public ModifyHapgRequest build() {
            return new ModifyHapgRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyHapgRequest> {
        public Builder hapgArn(String var1);

        public Builder label(String var1);

        public Builder partitionSerialList(Collection<String> var1);

        public Builder partitionSerialList(String ... var1);
    }
}

