/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudhsm.model.HapgListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHapgsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListHapgsResponse> {
    private final List<String> hapgList;
    private final String nextToken;

    private ListHapgsResponse(BuilderImpl builder) {
        this.hapgList = builder.hapgList;
        this.nextToken = builder.nextToken;
    }

    public List<String> hapgList() {
        return this.hapgList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hapgList() == null ? 0 : this.hapgList().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHapgsResponse)) {
            return false;
        }
        ListHapgsResponse other = (ListHapgsResponse)((Object)obj);
        if (other.hapgList() == null ^ this.hapgList() == null) {
            return false;
        }
        if (other.hapgList() != null && !other.hapgList().equals(this.hapgList())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hapgList() != null) {
            sb.append("HapgList: ").append(this.hapgList()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> hapgList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHapgsResponse model) {
            this.setHapgList(model.hapgList);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getHapgList() {
            return this.hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String ... hapgList) {
            this.hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListHapgsResponse build() {
            return new ListHapgsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListHapgsResponse> {
        public Builder hapgList(Collection<String> var1);

        public Builder hapgList(String ... var1);

        public Builder nextToken(String var1);
    }
}

