/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudhsm.model.ClientVersion;
import software.amazon.awssdk.services.cloudhsm.model.HapgListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetConfigRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetConfigRequest> {
    private final String clientArn;
    private final String clientVersion;
    private final List<String> hapgList;

    private GetConfigRequest(BuilderImpl builder) {
        this.clientArn = builder.clientArn;
        this.clientVersion = builder.clientVersion;
        this.hapgList = builder.hapgList;
    }

    public String clientArn() {
        return this.clientArn;
    }

    public String clientVersion() {
        return this.clientVersion;
    }

    public List<String> hapgList() {
        return this.hapgList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clientArn() == null ? 0 : this.clientArn().hashCode());
        hashCode = 31 * hashCode + (this.clientVersion() == null ? 0 : this.clientVersion().hashCode());
        hashCode = 31 * hashCode + (this.hapgList() == null ? 0 : this.hapgList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest)((Object)obj);
        if (other.clientArn() == null ^ this.clientArn() == null) {
            return false;
        }
        if (other.clientArn() != null && !other.clientArn().equals(this.clientArn())) {
            return false;
        }
        if (other.clientVersion() == null ^ this.clientVersion() == null) {
            return false;
        }
        if (other.clientVersion() != null && !other.clientVersion().equals(this.clientVersion())) {
            return false;
        }
        if (other.hapgList() == null ^ this.hapgList() == null) {
            return false;
        }
        return other.hapgList() == null || other.hapgList().equals(this.hapgList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientArn() != null) {
            sb.append("ClientArn: ").append(this.clientArn()).append(",");
        }
        if (this.clientVersion() != null) {
            sb.append("ClientVersion: ").append(this.clientVersion()).append(",");
        }
        if (this.hapgList() != null) {
            sb.append("HapgList: ").append(this.hapgList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clientArn;
        private String clientVersion;
        private List<String> hapgList;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigRequest model) {
            this.setClientArn(model.clientArn);
            this.setClientVersion(model.clientVersion);
            this.setHapgList(model.hapgList);
        }

        public final String getClientArn() {
            return this.clientArn;
        }

        @Override
        public final Builder clientArn(String clientArn) {
            this.clientArn = clientArn;
            return this;
        }

        public final void setClientArn(String clientArn) {
            this.clientArn = clientArn;
        }

        public final String getClientVersion() {
            return this.clientVersion;
        }

        @Override
        public final Builder clientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
            return this;
        }

        @Override
        public final Builder clientVersion(ClientVersion clientVersion) {
            this.clientVersion(clientVersion.toString());
            return this;
        }

        public final void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public final Collection<String> getHapgList() {
            return this.hapgList;
        }

        @Override
        public final Builder hapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hapgList(String ... hapgList) {
            this.hapgList(Arrays.asList(hapgList));
            return this;
        }

        public final void setHapgList(Collection<String> hapgList) {
            this.hapgList = HapgListCopier.copy(hapgList);
        }

        public GetConfigRequest build() {
            return new GetConfigRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetConfigRequest> {
        public Builder clientArn(String var1);

        public Builder clientVersion(String var1);

        public Builder clientVersion(ClientVersion var1);

        public Builder hapgList(Collection<String> var1);

        public Builder hapgList(String ... var1);
    }
}

