/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.ModifyHapgRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyHapgRequestModelMarshaller {
    private static final MarshallingInfo<String> HAPGARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HapgArn").isBinary(false).build();
    private static final MarshallingInfo<String> LABEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Label").isBinary(false).build();
    private static final MarshallingInfo<List> PARTITIONSERIALLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionSerialList").isBinary(false).build();
    private static final ModifyHapgRequestModelMarshaller INSTANCE = new ModifyHapgRequestModelMarshaller();

    private ModifyHapgRequestModelMarshaller() {
    }

    public static ModifyHapgRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyHapgRequest modifyHapgRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyHapgRequest), (String)"modifyHapgRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyHapgRequest.hapgArn(), HAPGARN_BINDING);
            protocolMarshaller.marshall((Object)modifyHapgRequest.label(), LABEL_BINDING);
            protocolMarshaller.marshall(modifyHapgRequest.partitionSerialList(), PARTITIONSERIALLIST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

