/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudhsm.model.CreateHsmRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateHsmRequestModelMarshaller {
    private static final MarshallingInfo<String> SUBNETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubnetId").isBinary(false).build();
    private static final MarshallingInfo<String> SSHKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SshKey").isBinary(false).build();
    private static final MarshallingInfo<String> ENIIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EniIp").isBinary(false).build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<String> SUBSCRIPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubscriptionType").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientToken").isBinary(false).build();
    private static final MarshallingInfo<String> SYSLOGIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SyslogIp").isBinary(false).build();
    private static final CreateHsmRequestModelMarshaller INSTANCE = new CreateHsmRequestModelMarshaller();

    private CreateHsmRequestModelMarshaller() {
    }

    public static CreateHsmRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateHsmRequest createHsmRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createHsmRequest), (String)"createHsmRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createHsmRequest.subnetId(), SUBNETID_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.sshKey(), SSHKEY_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.eniIp(), ENIIP_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.iamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.subscriptionTypeAsString(), SUBSCRIPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.clientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)createHsmRequest.syslogIp(), SYSLOGIP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

