/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMRequest;
import software.amazon.awssdk.services.cloudhsm.model.PartitionSerialListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyHapgRequest
extends CloudHSMRequest
implements ToCopyableBuilder<Builder, ModifyHapgRequest> {
    private final String hapgArn;
    private final String label;
    private final List<String> partitionSerialList;

    private ModifyHapgRequest(BuilderImpl builder) {
        super(builder);
        this.hapgArn = builder.hapgArn;
        this.label = builder.label;
        this.partitionSerialList = builder.partitionSerialList;
    }

    public String hapgArn() {
        return this.hapgArn;
    }

    public String label() {
        return this.label;
    }

    public List<String> partitionSerialList() {
        return this.partitionSerialList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hapgArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionSerialList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHapgRequest)) {
            return false;
        }
        ModifyHapgRequest other = (ModifyHapgRequest)((Object)obj);
        return Objects.equals(this.hapgArn(), other.hapgArn()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.partitionSerialList(), other.partitionSerialList());
    }

    public String toString() {
        return ToString.builder((String)"ModifyHapgRequest").add("HapgArn", (Object)this.hapgArn()).add("Label", (Object)this.label()).add("PartitionSerialList", this.partitionSerialList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HapgArn": {
                return Optional.of(clazz.cast(this.hapgArn()));
            }
            case "Label": {
                return Optional.of(clazz.cast(this.label()));
            }
            case "PartitionSerialList": {
                return Optional.of(clazz.cast(this.partitionSerialList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMRequest.BuilderImpl
    implements Builder {
        private String hapgArn;
        private String label;
        private List<String> partitionSerialList;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHapgRequest model) {
            super(model);
            this.hapgArn(model.hapgArn);
            this.label(model.label);
            this.partitionSerialList(model.partitionSerialList);
        }

        public final String getHapgArn() {
            return this.hapgArn;
        }

        @Override
        public final Builder hapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
            return this;
        }

        public final void setHapgArn(String hapgArn) {
            this.hapgArn = hapgArn;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<String> getPartitionSerialList() {
            return this.partitionSerialList;
        }

        @Override
        public final Builder partitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionSerialList(String ... partitionSerialList) {
            this.partitionSerialList(Arrays.asList(partitionSerialList));
            return this;
        }

        public final void setPartitionSerialList(Collection<String> partitionSerialList) {
            this.partitionSerialList = PartitionSerialListCopier.copy(partitionSerialList);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyHapgRequest build() {
            return new ModifyHapgRequest(this);
        }
    }

    public static interface Builder
    extends CloudHSMRequest.Builder,
    CopyableBuilder<Builder, ModifyHapgRequest> {
        public Builder hapgArn(String var1);

        public Builder label(String var1);

        public Builder partitionSerialList(Collection<String> var1);

        public Builder partitionSerialList(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

