/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudhsm.model.CloudHSMResponse;
import software.amazon.awssdk.services.cloudhsm.model.HsmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListHsmsResponse
extends CloudHSMResponse
implements ToCopyableBuilder<Builder, ListHsmsResponse> {
    private final List<String> hsmList;
    private final String nextToken;

    private ListHsmsResponse(BuilderImpl builder) {
        super(builder);
        this.hsmList = builder.hsmList;
        this.nextToken = builder.nextToken;
    }

    public List<String> hsmList() {
        return this.hsmList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHsmsResponse)) {
            return false;
        }
        ListHsmsResponse other = (ListHsmsResponse)((Object)obj);
        return Objects.equals(this.hsmList(), other.hsmList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListHsmsResponse").add("HsmList", this.hsmList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmList": {
                return Optional.of(clazz.cast(this.hsmList()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudHSMResponse.BuilderImpl
    implements Builder {
        private List<String> hsmList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHsmsResponse model) {
            super(model);
            this.hsmList(model.hsmList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getHsmList() {
            return this.hsmList;
        }

        @Override
        public final Builder hsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmList(String ... hsmList) {
            this.hsmList(Arrays.asList(hsmList));
            return this;
        }

        public final void setHsmList(Collection<String> hsmList) {
            this.hsmList = HsmListCopier.copy(hsmList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHsmsResponse build() {
            return new ListHsmsResponse(this);
        }
    }

    public static interface Builder
    extends CloudHSMResponse.Builder,
    CopyableBuilder<Builder, ListHsmsResponse> {
        public Builder hsmList(Collection<String> var1);

        public Builder hsmList(String ... var1);

        public Builder nextToken(String var1);
    }
}

