/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudhsm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudhsm.model.Tag;
import software.amazon.awssdk.services.cloudhsm.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTagsForResourceResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListTagsForResourceResponse> {
    private final List<Tag> tagList;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        this.tagList = builder.tagList;
    }

    public List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.tagList() == null ? 0 : this.tagList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse)((Object)obj);
        if (other.tagList() == null ^ this.tagList() == null) {
            return false;
        }
        return other.tagList() == null || other.tagList().equals(this.tagList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.tagList() != null) {
            sb.append("TagList: ").append(this.tagList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Tag> tagList = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            this.setTagList(model.tagList);
        }

        public final Collection<Tag> getTagList() {
            return this.tagList;
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            if (this.tagList == null) {
                this.tagList = new SdkInternalList(tagList.length);
            }
            for (Tag e : tagList) {
                this.tagList.add(e);
            }
            return this;
        }

        public final void setTagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
        }

        @SafeVarargs
        public final void setTagList(Tag ... tagList) {
            if (this.tagList == null) {
                this.tagList = new SdkInternalList(tagList.length);
            }
            for (Tag e : tagList) {
                this.tagList.add(e);
            }
        }

        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListTagsForResourceResponse> {
        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);
    }
}

