/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal;

import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointParams;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointProvider;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RuleUrl;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCloudFrontKeyValueStoreEndpointProvider
implements CloudFrontKeyValueStoreEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(CloudFrontKeyValueStoreEndpointParams params) {
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule0(params, new LocalState(params.region()));
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule1(params, locals);
        if (result.isResolved()) {
            return result;
        }
        return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule32(params, locals);
    }

    private static RuleResult endpointRule1(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule2(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule31(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (params.kvsArn() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule3(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule30(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        RuleArn parsedArn = null;
        parsedArn = RulesFunctions.awsParseArn(params.kvsArn());
        if (parsedArn != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule4(params, locals = locals.toBuilder().parsedArn(parsedArn).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule29(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if ("cloudfront".equals(locals.parsedArn().service())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule5(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule28(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if ("".equals(locals.parsedArn().region())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule6(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule27(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        String arnType = null;
        arnType = RulesFunctions.listAccess(locals.parsedArn().resourceId(), 0);
        if (arnType != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule7(params, locals = locals.toBuilder().arnType(arnType).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule26(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (!"".equals(locals.arnType())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule8(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule25(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if ("key-value-store".equals(locals.arnType())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule9(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule24(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if ("aws".equals(locals.parsedArn().partition())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule10(params, locals);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule19(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule23(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (locals.region() != null) {
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule11(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        RulePartition partitionResult = null;
        partitionResult = RulesFunctions.awsPartition(locals.region());
        if (partitionResult != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule12(params, locals = locals.toBuilder().partitionResult(partitionResult).build());
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule18(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (RulesFunctions.stringEquals(locals.partitionResult().name(), locals.parsedArn().partition())) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule13(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule17(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule14(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule16(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        RuleUrl url = null;
        url = RulesFunctions.parseURL(params.endpoint());
        if (url != null) {
            locals = locals.toBuilder().url(url).build();
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule15(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.parsedArn().accountId() + "." + locals.url().authority() + locals.url().path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule16(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Provided endpoint is not a valid URL");
    }

    private static RuleResult endpointRule17(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.parsedArn().accountId() + ".cloudfront-kvs.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule18(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Client was configured for partition `" + locals.partitionResult().name() + "` but Kvs ARN has `" + locals.parsedArn().partition() + "`");
    }

    private static RuleResult endpointRule19(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        if (params.endpoint() != null) {
            RuleResult result = DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule20(params, locals);
            if (result.isResolved()) {
                return result;
            }
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule22(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        RuleUrl url = null;
        url = RulesFunctions.parseURL(params.endpoint());
        if (url != null) {
            locals = locals.toBuilder().url(url).build();
            return DefaultCloudFrontKeyValueStoreEndpointProvider.endpointRule21(params, locals);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create(locals.url().scheme() + "://" + locals.parsedArn().accountId() + "." + locals.url().authority() + locals.url().path())).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule22(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Provided endpoint is not a valid URL");
    }

    private static RuleResult endpointRule23(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + locals.parsedArn().accountId() + ".cloudfront-kvs.global.api.aws")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4aAuthScheme.builder().signingName("cloudfront-keyvaluestore").signingRegionSet(Arrays.asList("*")).build())).build());
    }

    private static RuleResult endpointRule24(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("CloudFront-KeyValueStore is not supported in partition `" + locals.parsedArn().partition() + "`");
    }

    private static RuleResult endpointRule25(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("ARN resource type is invalid. Expected `key-value-store`, found: `" + locals.arnType() + "`");
    }

    private static RuleResult endpointRule26(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
    }

    private static RuleResult endpointRule27(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("No resource type found in the KVS ARN. Resource type must be `key-value-store`.");
    }

    private static RuleResult endpointRule28(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Provided ARN must be a global resource ARN. Found: `" + locals.parsedArn().region() + "`");
    }

    private static RuleResult endpointRule29(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Provided ARN is not a valid CloudFront Service ARN. Found: `" + locals.parsedArn().service() + "`");
    }

    private static RuleResult endpointRule30(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("KVS ARN must be a valid ARN");
    }

    private static RuleResult endpointRule31(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("KVS ARN must be provided to use this service");
    }

    private static RuleResult endpointRule32(CloudFrontKeyValueStoreEndpointParams params, LocalState locals) {
        return RuleResult.error("Invalid Configuration: FIPS is not supported with CloudFront-KeyValueStore.");
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static final class LocalStateBuilder {
        private RuleArn parsedArn;
        private String arnType;
        private String region;
        private RulePartition partitionResult;
        private RuleUrl url;

        LocalStateBuilder() {
            this.parsedArn = null;
            this.arnType = null;
            this.region = null;
            this.partitionResult = null;
            this.url = null;
        }

        LocalStateBuilder(LocalState locals) {
            this.parsedArn = locals.parsedArn;
            this.arnType = locals.arnType;
            this.region = locals.region;
            this.partitionResult = locals.partitionResult;
            this.url = locals.url;
        }

        public LocalStateBuilder parsedArn(RuleArn value) {
            this.parsedArn = value;
            return this;
        }

        public LocalStateBuilder arnType(String value) {
            this.arnType = value;
            return this;
        }

        public LocalStateBuilder region(String value) {
            this.region = value;
            return this;
        }

        public LocalStateBuilder partitionResult(RulePartition value) {
            this.partitionResult = value;
            return this;
        }

        public LocalStateBuilder url(RuleUrl value) {
            this.url = value;
            return this;
        }

        LocalState build() {
            return new LocalState(this);
        }
    }

    private static final class LocalState {
        private final RuleArn parsedArn;
        private final String arnType;
        private final String region;
        private final RulePartition partitionResult;
        private final RuleUrl url;

        LocalState() {
            this.parsedArn = null;
            this.arnType = null;
            this.region = null;
            this.partitionResult = null;
            this.url = null;
        }

        LocalState(Region region) {
            this.parsedArn = null;
            this.arnType = null;
            this.region = region != null ? region.id() : null;
            this.partitionResult = null;
            this.url = null;
        }

        LocalState(LocalStateBuilder builder) {
            this.parsedArn = builder.parsedArn;
            this.arnType = builder.arnType;
            this.region = builder.region;
            this.partitionResult = builder.partitionResult;
            this.url = builder.url;
        }

        public RuleArn parsedArn() {
            return this.parsedArn;
        }

        public String arnType() {
            return this.arnType;
        }

        public String region() {
            return this.region;
        }

        public RulePartition partitionResult() {
            return this.partitionResult;
        }

        public RuleUrl url() {
            return this.url;
        }

        public LocalStateBuilder toBuilder() {
            return new LocalStateBuilder(this);
        }
    }
}

