/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.CloudFrontKeyValueStoreResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetKeyResponse
extends CloudFrontKeyValueStoreResponse
implements ToCopyableBuilder<Builder, GetKeyResponse> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(GetKeyResponse.getter(GetKeyResponse::key)).setter(GetKeyResponse.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(GetKeyResponse.getter(GetKeyResponse::value)).setter(GetKeyResponse.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(GetKeyResponse.getter(GetKeyResponse::itemCount)).setter(GetKeyResponse.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<Long> TOTAL_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalSizeInBytes").getter(GetKeyResponse.getter(GetKeyResponse::totalSizeInBytes)).setter(GetKeyResponse.setter(Builder::totalSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD, ITEM_COUNT_FIELD, TOTAL_SIZE_IN_BYTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Key", KEY_FIELD);
            this.put("Value", VALUE_FIELD);
            this.put("ItemCount", ITEM_COUNT_FIELD);
            this.put("TotalSizeInBytes", TOTAL_SIZE_IN_BYTES_FIELD);
        }
    });
    private final String key;
    private final String value;
    private final Integer itemCount;
    private final Long totalSizeInBytes;

    private GetKeyResponse(BuilderImpl builder) {
        super(builder);
        this.key = builder.key;
        this.value = builder.value;
        this.itemCount = builder.itemCount;
        this.totalSizeInBytes = builder.totalSizeInBytes;
    }

    public final String key() {
        return this.key;
    }

    public final String value() {
        return this.value;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final Long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetKeyResponse)) {
            return false;
        }
        GetKeyResponse other = (GetKeyResponse)((Object)obj);
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.totalSizeInBytes(), other.totalSizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"GetKeyResponse").add("Key", (Object)this.key()).add("Value", (Object)(this.value() == null ? null : "*** Sensitive Data Redacted ***")).add("ItemCount", (Object)this.itemCount()).add("TotalSizeInBytes", (Object)this.totalSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "TotalSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.totalSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetKeyResponse, T> g) {
        return obj -> g.apply((GetKeyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontKeyValueStoreResponse.BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Integer itemCount;
        private Long totalSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(GetKeyResponse model) {
            super(model);
            this.key(model.key);
            this.value(model.value);
            this.itemCount(model.itemCount);
            this.totalSizeInBytes(model.totalSizeInBytes);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Long getTotalSizeInBytes() {
            return this.totalSizeInBytes;
        }

        public final void setTotalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
        }

        @Override
        public final Builder totalSizeInBytes(Long totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        @Override
        public GetKeyResponse build() {
            return new GetKeyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontKeyValueStoreResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetKeyResponse> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder itemCount(Integer var1);

        public Builder totalSizeInBytes(Long var1);
    }
}

