/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.auth.scheme.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.auth.scheme.CloudFrontKeyValueStoreAuthSchemeParams;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.auth.scheme.internal.CloudFrontKeyValueStoreEndpointResolverAware;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.endpoints.CloudFrontKeyValueStoreEndpointProvider;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultCloudFrontKeyValueStoreAuthSchemeParams
implements CloudFrontKeyValueStoreAuthSchemeParams,
CloudFrontKeyValueStoreEndpointResolverAware {
    private final String operation;
    private final Region region;
    private final String kvsARN;
    private final Boolean useFIPS;
    private final String endpoint;
    private final CloudFrontKeyValueStoreEndpointProvider endpointProvider;

    private DefaultCloudFrontKeyValueStoreAuthSchemeParams(Builder builder) {
        this.operation = (String)Validate.paramNotNull((Object)builder.operation, (String)"operation");
        this.region = builder.region;
        this.kvsARN = builder.kvsARN;
        this.useFIPS = (Boolean)Validate.paramNotNull((Object)builder.useFIPS, (String)"useFIPS");
        this.endpoint = builder.endpoint;
        this.endpointProvider = builder.endpointProvider;
    }

    public static CloudFrontKeyValueStoreAuthSchemeParams.Builder builder() {
        return new Builder();
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    public String kvsArn() {
        return this.kvsARN;
    }

    @Override
    public Boolean useFips() {
        return this.useFIPS;
    }

    @Override
    public String endpoint() {
        return this.endpoint;
    }

    @Override
    public CloudFrontKeyValueStoreEndpointProvider endpointProvider() {
        return this.endpointProvider;
    }

    @Override
    public CloudFrontKeyValueStoreAuthSchemeParams.Builder toBuilder() {
        return new Builder(this);
    }

    private static final class Builder
    implements CloudFrontKeyValueStoreAuthSchemeParams.Builder,
    CloudFrontKeyValueStoreEndpointResolverAware.Builder {
        private String operation;
        private Region region;
        private String kvsARN;
        private Boolean useFIPS = false;
        private String endpoint;
        private CloudFrontKeyValueStoreEndpointProvider endpointProvider;

        Builder() {
        }

        Builder(DefaultCloudFrontKeyValueStoreAuthSchemeParams params) {
            this.operation = params.operation;
            this.region = params.region;
            this.kvsARN = params.kvsARN;
            this.useFIPS = params.useFIPS;
            this.endpoint = params.endpoint;
            this.endpointProvider = params.endpointProvider;
        }

        @Override
        public Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder kvsArn(String kvsARN) {
            this.kvsARN = kvsARN;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder endpointProvider(CloudFrontKeyValueStoreEndpointProvider endpointProvider) {
            this.endpointProvider = endpointProvider;
            return this;
        }

        @Override
        public CloudFrontKeyValueStoreAuthSchemeParams build() {
            return new DefaultCloudFrontKeyValueStoreAuthSchemeParams(this);
        }
    }
}

