/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfrontkeyvaluestore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.CloudFrontKeyValueStoreClient;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysRequest;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponse;
import software.amazon.awssdk.services.cloudfrontkeyvaluestore.model.ListKeysResponseListItem;

public class ListKeysIterable
implements SdkIterable<ListKeysResponse> {
    private final CloudFrontKeyValueStoreClient client;
    private final ListKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListKeysIterable(CloudFrontKeyValueStoreClient client, ListKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public Iterator<ListKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListKeysResponseListItem> items() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListKeysResponseFetcher
    implements SyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListKeysResponse nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysIterable.this.client.listKeys(ListKeysIterable.this.firstRequest);
            }
            return ListKeysIterable.this.client.listKeys((ListKeysRequest)((Object)ListKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

