/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CookieNames;
import software.amazon.awssdk.services.cloudfront.model.ItemSelection;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CookiePreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CookiePreference> {
    private static final SdkField<String> FORWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CookiePreference.getter(CookiePreference::forwardAsString)).setter(CookiePreference.setter(Builder::forward)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Forward").unmarshallLocationName("Forward").build()}).build();
    private static final SdkField<CookieNames> WHITELISTED_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CookiePreference.getter(CookiePreference::whitelistedNames)).setter(CookiePreference.setter(Builder::whitelistedNames)).constructor(CookieNames::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhitelistedNames").unmarshallLocationName("WhitelistedNames").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORWARD_FIELD, WHITELISTED_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String forward;
    private final CookieNames whitelistedNames;

    private CookiePreference(BuilderImpl builder) {
        this.forward = builder.forward;
        this.whitelistedNames = builder.whitelistedNames;
    }

    public ItemSelection forward() {
        return ItemSelection.fromValue(this.forward);
    }

    public String forwardAsString() {
        return this.forward;
    }

    public CookieNames whitelistedNames() {
        return this.whitelistedNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forwardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistedNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CookiePreference)) {
            return false;
        }
        CookiePreference other = (CookiePreference)obj;
        return Objects.equals(this.forwardAsString(), other.forwardAsString()) && Objects.equals(this.whitelistedNames(), other.whitelistedNames());
    }

    public String toString() {
        return ToString.builder((String)"CookiePreference").add("Forward", (Object)this.forwardAsString()).add("WhitelistedNames", (Object)this.whitelistedNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Forward": {
                return Optional.ofNullable(clazz.cast(this.forwardAsString()));
            }
            case "WhitelistedNames": {
                return Optional.ofNullable(clazz.cast(this.whitelistedNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CookiePreference, T> g) {
        return obj -> g.apply((CookiePreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String forward;
        private CookieNames whitelistedNames;

        private BuilderImpl() {
        }

        private BuilderImpl(CookiePreference model) {
            this.forward(model.forward);
            this.whitelistedNames(model.whitelistedNames);
        }

        public final String getForwardAsString() {
            return this.forward;
        }

        @Override
        public final Builder forward(String forward) {
            this.forward = forward;
            return this;
        }

        @Override
        public final Builder forward(ItemSelection forward) {
            this.forward(forward.toString());
            return this;
        }

        public final void setForward(String forward) {
            this.forward = forward;
        }

        public final CookieNames.Builder getWhitelistedNames() {
            return this.whitelistedNames != null ? this.whitelistedNames.toBuilder() : null;
        }

        @Override
        public final Builder whitelistedNames(CookieNames whitelistedNames) {
            this.whitelistedNames = whitelistedNames;
            return this;
        }

        public final void setWhitelistedNames(CookieNames.BuilderImpl whitelistedNames) {
            this.whitelistedNames = whitelistedNames != null ? whitelistedNames.build() : null;
        }

        public CookiePreference build() {
            return new CookiePreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CookiePreference> {
        public Builder forward(String var1);

        public Builder forward(ItemSelection var1);

        public Builder whitelistedNames(CookieNames var1);

        default public Builder whitelistedNames(Consumer<CookieNames.Builder> whitelistedNames) {
            return this.whitelistedNames((CookieNames)((CookieNames.Builder)CookieNames.builder().applyMutation(whitelistedNames)).build());
        }
    }
}

