/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomOriginConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomOriginConfig> {
    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CustomOriginConfig.getter(CustomOriginConfig::httpPort)).setter(CustomOriginConfig.setter(Builder::httpPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPPort").unmarshallLocationName("HTTPPort").build()}).build();
    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CustomOriginConfig.getter(CustomOriginConfig::httpsPort)).setter(CustomOriginConfig.setter(Builder::httpsPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPSPort").unmarshallLocationName("HTTPSPort").build()}).build();
    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CustomOriginConfig.getter(CustomOriginConfig::originProtocolPolicyAsString)).setter(CustomOriginConfig.setter(Builder::originProtocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy").unmarshallLocationName("OriginProtocolPolicy").build()}).build();
    private static final SdkField<OriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CustomOriginConfig.getter(CustomOriginConfig::originSslProtocols)).setter(CustomOriginConfig.setter(Builder::originSslProtocols)).constructor(OriginSslProtocols::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols").unmarshallLocationName("OriginSslProtocols").build()}).build();
    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CustomOriginConfig.getter(CustomOriginConfig::originReadTimeout)).setter(CustomOriginConfig.setter(Builder::originReadTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout").unmarshallLocationName("OriginReadTimeout").build()}).build();
    private static final SdkField<Integer> ORIGIN_KEEPALIVE_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CustomOriginConfig.getter(CustomOriginConfig::originKeepaliveTimeout)).setter(CustomOriginConfig.setter(Builder::originKeepaliveTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginKeepaliveTimeout").unmarshallLocationName("OriginKeepaliveTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_PORT_FIELD, HTTPS_PORT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_SSL_PROTOCOLS_FIELD, ORIGIN_READ_TIMEOUT_FIELD, ORIGIN_KEEPALIVE_TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer httpPort;
    private final Integer httpsPort;
    private final String originProtocolPolicy;
    private final OriginSslProtocols originSslProtocols;
    private final Integer originReadTimeout;
    private final Integer originKeepaliveTimeout;

    private CustomOriginConfig(BuilderImpl builder) {
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
        this.originReadTimeout = builder.originReadTimeout;
        this.originKeepaliveTimeout = builder.originKeepaliveTimeout;
    }

    public Integer httpPort() {
        return this.httpPort;
    }

    public Integer httpsPort() {
        return this.httpsPort;
    }

    public OriginProtocolPolicy originProtocolPolicy() {
        return OriginProtocolPolicy.fromValue(this.originProtocolPolicy);
    }

    public String originProtocolPolicyAsString() {
        return this.originProtocolPolicy;
    }

    public OriginSslProtocols originSslProtocols() {
        return this.originSslProtocols;
    }

    public Integer originReadTimeout() {
        return this.originReadTimeout;
    }

    public Integer originKeepaliveTimeout() {
        return this.originKeepaliveTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.originProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originSslProtocols());
        hashCode = 31 * hashCode + Objects.hashCode(this.originReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.originKeepaliveTimeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOriginConfig)) {
            return false;
        }
        CustomOriginConfig other = (CustomOriginConfig)obj;
        return Objects.equals(this.httpPort(), other.httpPort()) && Objects.equals(this.httpsPort(), other.httpsPort()) && Objects.equals(this.originProtocolPolicyAsString(), other.originProtocolPolicyAsString()) && Objects.equals(this.originSslProtocols(), other.originSslProtocols()) && Objects.equals(this.originReadTimeout(), other.originReadTimeout()) && Objects.equals(this.originKeepaliveTimeout(), other.originKeepaliveTimeout());
    }

    public String toString() {
        return ToString.builder((String)"CustomOriginConfig").add("HTTPPort", (Object)this.httpPort()).add("HTTPSPort", (Object)this.httpsPort()).add("OriginProtocolPolicy", (Object)this.originProtocolPolicyAsString()).add("OriginSslProtocols", (Object)this.originSslProtocols()).add("OriginReadTimeout", (Object)this.originReadTimeout()).add("OriginKeepaliveTimeout", (Object)this.originKeepaliveTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HTTPPort": {
                return Optional.ofNullable(clazz.cast(this.httpPort()));
            }
            case "HTTPSPort": {
                return Optional.ofNullable(clazz.cast(this.httpsPort()));
            }
            case "OriginProtocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.originProtocolPolicyAsString()));
            }
            case "OriginSslProtocols": {
                return Optional.ofNullable(clazz.cast(this.originSslProtocols()));
            }
            case "OriginReadTimeout": {
                return Optional.ofNullable(clazz.cast(this.originReadTimeout()));
            }
            case "OriginKeepaliveTimeout": {
                return Optional.ofNullable(clazz.cast(this.originKeepaliveTimeout()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomOriginConfig, T> g) {
        return obj -> g.apply((CustomOriginConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer httpPort;
        private Integer httpsPort;
        private String originProtocolPolicy;
        private OriginSslProtocols originSslProtocols;
        private Integer originReadTimeout;
        private Integer originKeepaliveTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOriginConfig model) {
            this.httpPort(model.httpPort);
            this.httpsPort(model.httpsPort);
            this.originProtocolPolicy(model.originProtocolPolicy);
            this.originSslProtocols(model.originSslProtocols);
            this.originReadTimeout(model.originReadTimeout);
            this.originKeepaliveTimeout(model.originKeepaliveTimeout);
        }

        public final Integer getHttpPort() {
            return this.httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        public final Integer getHttpsPort() {
            return this.httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        public final String getOriginProtocolPolicyAsString() {
            return this.originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy.toString());
            return this;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        public final OriginSslProtocols.Builder getOriginSslProtocols() {
            return this.originSslProtocols != null ? this.originSslProtocols.toBuilder() : null;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public final void setOriginSslProtocols(OriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        public final Integer getOriginReadTimeout() {
            return this.originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        public final Integer getOriginKeepaliveTimeout() {
            return this.originKeepaliveTimeout;
        }

        @Override
        public final Builder originKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
            return this;
        }

        public final void setOriginKeepaliveTimeout(Integer originKeepaliveTimeout) {
            this.originKeepaliveTimeout = originKeepaliveTimeout;
        }

        public CustomOriginConfig build() {
            return new CustomOriginConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomOriginConfig> {
        public Builder httpPort(Integer var1);

        public Builder httpsPort(Integer var1);

        public Builder originProtocolPolicy(String var1);

        public Builder originProtocolPolicy(OriginProtocolPolicy var1);

        public Builder originSslProtocols(OriginSslProtocols var1);

        default public Builder originSslProtocols(Consumer<OriginSslProtocols.Builder> originSslProtocols) {
            return this.originSslProtocols((OriginSslProtocols)((OriginSslProtocols.Builder)OriginSslProtocols.builder().applyMutation(originSslProtocols)).build());
        }

        public Builder originReadTimeout(Integer var1);

        public Builder originKeepaliveTimeout(Integer var1);
    }
}

