/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCloudFrontOriginAccessIdentityRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
    private static final SdkField<CloudFrontOriginAccessIdentityConfig> CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateCloudFrontOriginAccessIdentityRequest.getter(UpdateCloudFrontOriginAccessIdentityRequest::cloudFrontOriginAccessIdentityConfig)).setter(UpdateCloudFrontOriginAccessIdentityRequest.setter(Builder::cloudFrontOriginAccessIdentityConfig)).constructor(CloudFrontOriginAccessIdentityConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFrontOriginAccessIdentityConfig").unmarshallLocationName("CloudFrontOriginAccessIdentityConfig").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCloudFrontOriginAccessIdentityRequest.getter(UpdateCloudFrontOriginAccessIdentityRequest::id)).setter(UpdateCloudFrontOriginAccessIdentityRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateCloudFrontOriginAccessIdentityRequest.getter(UpdateCloudFrontOriginAccessIdentityRequest::ifMatch)).setter(UpdateCloudFrontOriginAccessIdentityRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FRONT_ORIGIN_ACCESS_IDENTITY_CONFIG_FIELD, ID_FIELD, IF_MATCH_FIELD));
    private final CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
    private final String id;
    private final String ifMatch;

    private UpdateCloudFrontOriginAccessIdentityRequest(BuilderImpl builder) {
        super(builder);
        this.cloudFrontOriginAccessIdentityConfig = builder.cloudFrontOriginAccessIdentityConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    public CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig() {
        return this.cloudFrontOriginAccessIdentityConfig;
    }

    public String id() {
        return this.id;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFrontOriginAccessIdentityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCloudFrontOriginAccessIdentityRequest)) {
            return false;
        }
        UpdateCloudFrontOriginAccessIdentityRequest other = (UpdateCloudFrontOriginAccessIdentityRequest)((Object)obj);
        return Objects.equals(this.cloudFrontOriginAccessIdentityConfig(), other.cloudFrontOriginAccessIdentityConfig()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.ifMatch(), other.ifMatch());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCloudFrontOriginAccessIdentityRequest").add("CloudFrontOriginAccessIdentityConfig", (Object)this.cloudFrontOriginAccessIdentityConfig()).add("Id", (Object)this.id()).add("IfMatch", (Object)this.ifMatch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudFrontOriginAccessIdentityConfig": {
                return Optional.ofNullable(clazz.cast(this.cloudFrontOriginAccessIdentityConfig()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCloudFrontOriginAccessIdentityRequest, T> g) {
        return obj -> g.apply((UpdateCloudFrontOriginAccessIdentityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig;
        private String id;
        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCloudFrontOriginAccessIdentityRequest model) {
            super(model);
            this.cloudFrontOriginAccessIdentityConfig(model.cloudFrontOriginAccessIdentityConfig);
            this.id(model.id);
            this.ifMatch(model.ifMatch);
        }

        public final CloudFrontOriginAccessIdentityConfig.Builder getCloudFrontOriginAccessIdentityConfig() {
            return this.cloudFrontOriginAccessIdentityConfig != null ? this.cloudFrontOriginAccessIdentityConfig.toBuilder() : null;
        }

        @Override
        public final Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig;
            return this;
        }

        public final void setCloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig.BuilderImpl cloudFrontOriginAccessIdentityConfig) {
            this.cloudFrontOriginAccessIdentityConfig = cloudFrontOriginAccessIdentityConfig != null ? cloudFrontOriginAccessIdentityConfig.build() : null;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCloudFrontOriginAccessIdentityRequest build() {
            return new UpdateCloudFrontOriginAccessIdentityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCloudFrontOriginAccessIdentityRequest> {
        public Builder cloudFrontOriginAccessIdentityConfig(CloudFrontOriginAccessIdentityConfig var1);

        default public Builder cloudFrontOriginAccessIdentityConfig(Consumer<CloudFrontOriginAccessIdentityConfig.Builder> cloudFrontOriginAccessIdentityConfig) {
            return this.cloudFrontOriginAccessIdentityConfig((CloudFrontOriginAccessIdentityConfig)((CloudFrontOriginAccessIdentityConfig.Builder)CloudFrontOriginAccessIdentityConfig.builder().applyMutation(cloudFrontOriginAccessIdentityConfig)).build());
        }

        public Builder id(String var1);

        public Builder ifMatch(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

