/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.OriginGroupMember;
import software.amazon.awssdk.services.cloudfront.model.OriginGroupMemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OriginGroupMembers
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OriginGroupMembers> {
    private static final SdkField<Integer> QUANTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(OriginGroupMembers.getter(OriginGroupMembers::quantity)).setter(OriginGroupMembers.setter(Builder::quantity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity").unmarshallLocationName("Quantity").build()}).build();
    private static final SdkField<List<OriginGroupMember>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(OriginGroupMembers.getter(OriginGroupMembers::items)).setter(OriginGroupMembers.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").unmarshallLocationName("Items").build(), ListTrait.builder().memberLocationName("OriginGroupMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OriginGroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroupMember").unmarshallLocationName("OriginGroupMember").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUANTITY_FIELD, ITEMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer quantity;
    private final List<OriginGroupMember> items;

    private OriginGroupMembers(BuilderImpl builder) {
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<OriginGroupMember> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.quantity());
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginGroupMembers)) {
            return false;
        }
        OriginGroupMembers other = (OriginGroupMembers)obj;
        return Objects.equals(this.quantity(), other.quantity()) && Objects.equals(this.items(), other.items());
    }

    public String toString() {
        return ToString.builder((String)"OriginGroupMembers").add("Quantity", (Object)this.quantity()).add("Items", this.items()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Quantity": {
                return Optional.ofNullable(clazz.cast(this.quantity()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginGroupMembers, T> g) {
        return obj -> g.apply((OriginGroupMembers)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer quantity;
        private List<OriginGroupMember> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OriginGroupMembers model) {
            this.quantity(model.quantity);
            this.items(model.items);
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<OriginGroupMember.Builder> getItems() {
            return this.items != null ? (Collection)this.items.stream().map(OriginGroupMember::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<OriginGroupMember> items) {
            this.items = OriginGroupMemberListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(OriginGroupMember ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<OriginGroupMember.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (OriginGroupMember)((OriginGroupMember.Builder)OriginGroupMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<OriginGroupMember.BuilderImpl> items) {
            this.items = OriginGroupMemberListCopier.copyFromBuilder(items);
        }

        public OriginGroupMembers build() {
            return new OriginGroupMembers(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OriginGroupMembers> {
        public Builder quantity(Integer var1);

        public Builder items(Collection<OriginGroupMember> var1);

        public Builder items(OriginGroupMember ... var1);

        public Builder items(Consumer<OriginGroupMember.Builder> ... var1);
    }
}

