/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.InvalidationSummary;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsForDistributionTenantResponse;

public class ListInvalidationsForDistributionTenantPublisher
implements SdkPublisher<ListInvalidationsForDistributionTenantResponse> {
    private final CloudFrontAsyncClient client;
    private final ListInvalidationsForDistributionTenantRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvalidationsForDistributionTenantPublisher(CloudFrontAsyncClient client, ListInvalidationsForDistributionTenantRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvalidationsForDistributionTenantPublisher(CloudFrontAsyncClient client, ListInvalidationsForDistributionTenantRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvalidationsForDistributionTenantResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvalidationsForDistributionTenantResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InvalidationSummary> items() {
        return this.flatMapIterable(response -> response.invalidationList().items());
    }

    private class ListInvalidationsForDistributionTenantResponseFetcher
    implements AsyncPageFetcher<ListInvalidationsForDistributionTenantResponse> {
        private ListInvalidationsForDistributionTenantResponseFetcher() {
        }

        public boolean hasNextPage(ListInvalidationsForDistributionTenantResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.invalidationList().nextMarker());
        }

        public CompletableFuture<ListInvalidationsForDistributionTenantResponse> nextPage(ListInvalidationsForDistributionTenantResponse previousPage) {
            if (previousPage == null) {
                return ListInvalidationsForDistributionTenantPublisher.this.client.listInvalidationsForDistributionTenant(ListInvalidationsForDistributionTenantPublisher.this.firstRequest);
            }
            return ListInvalidationsForDistributionTenantPublisher.this.client.listInvalidationsForDistributionTenant((ListInvalidationsForDistributionTenantRequest)((Object)ListInvalidationsForDistributionTenantPublisher.this.firstRequest.toBuilder().marker(previousPage.invalidationList().nextMarker()).build()));
        }
    }
}

