/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByConnectionModeResponse;

public class ListDistributionsByConnectionModePublisher
implements SdkPublisher<ListDistributionsByConnectionModeResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionsByConnectionModeRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionsByConnectionModePublisher(CloudFrontAsyncClient client, ListDistributionsByConnectionModeRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionsByConnectionModePublisher(CloudFrontAsyncClient client, ListDistributionsByConnectionModeRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionsByConnectionModeResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionsByConnectionModeResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionSummary> items() {
        return this.flatMapIterable(response -> response.distributionList().items());
    }

    private class ListDistributionsByConnectionModeResponseFetcher
    implements AsyncPageFetcher<ListDistributionsByConnectionModeResponse> {
        private ListDistributionsByConnectionModeResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsByConnectionModeResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.distributionList().nextMarker());
        }

        public CompletableFuture<ListDistributionsByConnectionModeResponse> nextPage(ListDistributionsByConnectionModeResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsByConnectionModePublisher.this.client.listDistributionsByConnectionMode(ListDistributionsByConnectionModePublisher.this.firstRequest);
            }
            return ListDistributionsByConnectionModePublisher.this.client.listDistributionsByConnectionMode((ListDistributionsByConnectionModeRequest)((Object)ListDistributionsByConnectionModePublisher.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

