/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomizationActionType {
    OVERRIDE("override"),
    DISABLE("disable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomizationActionType> VALUE_MAP;
    private final String value;

    private CustomizationActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomizationActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomizationActionType> knownValues() {
        EnumSet<CustomizationActionType> knownValues = EnumSet.allOf(CustomizationActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomizationActionType.class, CustomizationActionType::toString);
    }
}

